/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.ejbtimer;

import java.util.Collection;
import java.util.Iterator;
import javax.ejb.FinderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.ejb.LocalTimerEntity;
import org.jbpm.ejb.LocalTimerEntityHome;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Job;
import org.jbpm.job.Timer;
import org.jbpm.scheduler.SchedulerService;

public class EntitySchedulerService
implements SchedulerService {
    private static final long serialVersionUID = 2L;
    private JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
    private LocalTimerEntityHome timerEntityHome;
    private static final Log log = LogFactory.getLog((Class)EntitySchedulerService.class);

    public EntitySchedulerService(LocalTimerEntityHome timerEntityHome) {
        if (this.jbpmContext == null) {
            throw new JbpmException("no active jbpm context");
        }
        this.timerEntityHome = timerEntityHome;
    }

    public void createTimer(Timer timer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("creating " + timer));
        }
        this.jbpmContext.getJobSession().saveJob((Job)timer);
        this.jbpmContext.getSession().flush();
        try {
            LocalTimerEntity timerEntity = this.timerEntityHome.findByPrimaryKey(new Long(timer.getId()));
            timerEntity.createTimer(timer);
        }
        catch (FinderException e) {
            log.error((Object)("failed to retrieve entity for " + timer), (Throwable)e);
        }
    }

    public void deleteTimer(Timer timer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleting " + timer));
        }
        try {
            LocalTimerEntity timerEntity = this.timerEntityHome.findByPrimaryKey(new Long(timer.getId()));
            timerEntity.cancelTimer(timer);
        }
        catch (FinderException e) {
            log.error((Object)("failed to retrieve entity for " + timer), (Throwable)e);
        }
        this.jbpmContext.getJobSession().deleteJob((Job)timer);
    }

    public void deleteTimersByName(String timerName, Token token) {
        try {
            Collection timerEntities = this.timerEntityHome.findByNameAndTokenId(timerName, new Long(token.getId()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("found " + timerEntities.size() + " timer entities by name '" + timerName + "' for " + token));
            }
            Iterator i = timerEntities.iterator();
            while (i.hasNext()) {
                LocalTimerEntity timerEntity = (LocalTimerEntity)i.next();
                timerEntity.cancelTimersByName(timerName, token);
            }
        }
        catch (FinderException e) {
            log.error((Object)("failed to retrieve timer entities by name '" + timerName + "' for " + token), (Throwable)e);
        }
        this.jbpmContext.getJobSession().deleteTimersByName(timerName, token);
    }

    public void deleteTimersByProcessInstance(ProcessInstance processInstance) {
        try {
            Collection timerEntities = this.timerEntityHome.findByProcessInstanceId(new Long(processInstance.getId()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("found " + timerEntities.size() + " timer entities for " + processInstance));
            }
            Iterator i = timerEntities.iterator();
            while (i.hasNext()) {
                LocalTimerEntity timerEntity = (LocalTimerEntity)i.next();
                timerEntity.cancelTimersForProcessInstance(processInstance);
            }
        }
        catch (FinderException e) {
            log.error((Object)("failed to retrieve timer entities for " + processInstance), (Throwable)e);
        }
        this.jbpmContext.getJobSession().deleteJobsForProcessInstance(processInstance);
    }

    public void close() {
    }
}

