/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.filters;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.io.InputSupplier;
import java.net.URI;
import javax.annotation.Resource;
import javax.crypto.Mac;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpException;
import org.jclouds.io.InputSuppliers;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;

@Singleton
public class ShareUrl
implements Function<String, URI> {
    private final String uid;
    private final byte[] key;
    private final Supplier<URI> provider;
    private final javax.inject.Provider<Long> timeStampProvider;
    private final javax.inject.Provider<UriBuilder> uriBuilders;
    private final Crypto crypto;
    @Resource
    Logger logger = Logger.NULL;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public ShareUrl(@Named(value="jclouds.identity") String uid, @Named(value="jclouds.credential") String encodedKey, @Provider Supplier<URI> provider, @TimeStamp javax.inject.Provider<Long> timeStampProvider, javax.inject.Provider<UriBuilder> uriBuilders, Crypto crypto) {
        this.uid = uid;
        this.key = CryptoStreams.base64((String)encodedKey);
        this.provider = provider;
        this.uriBuilders = uriBuilders;
        this.timeStampProvider = timeStampProvider;
        this.crypto = crypto;
    }

    public URI apply(String path) throws HttpException {
        String requestedResource = "/rest/namespace/" + path;
        long expires = (Long)this.timeStampProvider.get();
        String signature = this.signString(this.createStringToSign(requestedResource, expires));
        return ((UriBuilder)this.uriBuilders.get()).uri((URI)this.provider.get()).path(requestedResource).queryParam("uid", new Object[]{this.uid}).queryParam("expires", new Object[]{expires}).queryParam("signature", new Object[]{signature}).build(new Object[0]);
    }

    public String createStringToSign(String requestedResource, long expires) {
        StringBuilder toSign = new StringBuilder();
        toSign.append("GET\n");
        toSign.append(requestedResource.toLowerCase()).append("\n");
        toSign.append(this.uid).append("\n");
        toSign.append(expires);
        return toSign.toString();
    }

    public String signString(String toSign) {
        String signature;
        try {
            signature = CryptoStreams.base64((byte[])CryptoStreams.mac((InputSupplier)InputSuppliers.of((String)toSign), (Mac)this.crypto.hmacSHA1(this.key)));
        }
        catch (Exception e) {
            throw new HttpException("error signing request", (Throwable)e);
        }
        return signature;
    }
}

