/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Provides;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.atmos.binders.BindMetadataToHeaders;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.domain.BoundedSet;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.domain.SystemMetadata;
import org.jclouds.atmos.domain.UserMetadata;
import org.jclouds.atmos.filters.SignRequest;
import org.jclouds.atmos.functions.AtmosObjectName;
import org.jclouds.atmos.functions.ParseDirectoryListFromContentAndHeaders;
import org.jclouds.atmos.functions.ParseObjectFromHeadersAndHttpContent;
import org.jclouds.atmos.functions.ParseSystemMetadataFromHeaders;
import org.jclouds.atmos.functions.ParseUserMetadataFromHeaders;
import org.jclouds.atmos.functions.ReturnEndpointIfAlreadyExists;
import org.jclouds.atmos.functions.ReturnTrueIfGroupACLIsOtherRead;
import org.jclouds.atmos.options.ListOptions;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.blobstore.functions.ThrowContainerNotFoundOn404;
import org.jclouds.blobstore.functions.ThrowKeyNotFoundOn404;
import org.jclouds.http.options.GetOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={SignRequest.class})
@SkipEncoding(value={47})
@Path(value="/rest/namespace")
public interface AtmosAsyncClient {
    @Provides
    public AtmosObject newObject();

    @GET
    @ResponseParser(value=ParseDirectoryListFromContentAndHeaders.class)
    @Consumes(value={"text/xml"})
    public ListenableFuture<BoundedSet<? extends DirectoryEntry>> listDirectories(ListOptions ... var1);

    @GET
    @Path(value="/{directoryName}/")
    @ResponseParser(value=ParseDirectoryListFromContentAndHeaders.class)
    @ExceptionParser(value=ThrowContainerNotFoundOn404.class)
    @Consumes(value={"text/xml"})
    public ListenableFuture<BoundedSet<? extends DirectoryEntry>> listDirectory(@PathParam(value="directoryName") String var1, ListOptions ... var2);

    @POST
    @Path(value="/{directoryName}/")
    @ExceptionParser(value=ReturnEndpointIfAlreadyExists.class)
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"*/*"})
    public ListenableFuture<URI> createDirectory(@PathParam(value="directoryName") String var1, PutOptions ... var2);

    @POST
    @Path(value="/{parent}/{name}")
    @Consumes(value={"*/*"})
    public ListenableFuture<URI> createFile(@PathParam(value="parent") String var1, @PathParam(value="name") @ParamParser(value=AtmosObjectName.class) @BinderParam(value=BindMetadataToHeaders.class) AtmosObject var2, PutOptions ... var3);

    @PUT
    @Path(value="/{parent}/{name}")
    @ExceptionParser(value=ThrowKeyNotFoundOn404.class)
    @Consumes(value={"*/*"})
    public ListenableFuture<Void> updateFile(@PathParam(value="parent") String var1, @PathParam(value="name") @ParamParser(value=AtmosObjectName.class) @BinderParam(value=BindMetadataToHeaders.class) AtmosObject var2, PutOptions ... var3);

    @GET
    @ResponseParser(value=ParseObjectFromHeadersAndHttpContent.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public ListenableFuture<AtmosObject> readFile(@PathParam(value="path") String var1, GetOptions ... var2);

    @HEAD
    @ResponseParser(value=ParseObjectFromHeadersAndHttpContent.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public ListenableFuture<AtmosObject> headFile(@PathParam(value="path") String var1);

    @HEAD
    @ResponseParser(value=ParseSystemMetadataFromHeaders.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public ListenableFuture<SystemMetadata> getSystemMetadata(@PathParam(value="path") String var1);

    @HEAD
    @ResponseParser(value=ParseUserMetadataFromHeaders.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/{path}")
    @QueryParams(keys={"metadata/user"})
    @Consumes(value={"*/*"})
    public ListenableFuture<UserMetadata> getUserMetadata(@PathParam(value="path") String var1);

    @DELETE
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public ListenableFuture<Void> deletePath(@PathParam(value="path") String var1);

    @HEAD
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public ListenableFuture<Boolean> pathExists(@PathParam(value="path") String var1);

    @HEAD
    @ResponseParser(value=ReturnTrueIfGroupACLIsOtherRead.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> isPublic(@PathParam(value="path") String var1);
}

