/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.openstack.keystone.v2_0.config.CredentialType;

@CredentialType(value="passwordCredentials")
public class PasswordCredentials {
    private final String username;
    private final String password;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromPasswordCredentials(this);
    }

    public static PasswordCredentials createWithUsernameAndPassword(String username, String password) {
        return new PasswordCredentials(username, password);
    }

    @ConstructorProperties(value={"username", "password"})
    protected PasswordCredentials(String username, String password) {
        this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username");
        this.password = (String)Preconditions.checkNotNull((Object)password, (Object)"password");
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.username, this.password});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PasswordCredentials that = (PasswordCredentials)PasswordCredentials.class.cast(obj);
        return Objects.equal((Object)this.username, (Object)that.username) && Objects.equal((Object)this.password, (Object)that.password);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("username", (Object)this.username).add("password", (Object)this.password);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String username;
        protected String password;

        protected abstract T self();

        public T username(String username) {
            this.username = username;
            return this.self();
        }

        public T password(String password) {
            this.password = password;
            return this.self();
        }

        public PasswordCredentials build() {
            return new PasswordCredentials(this.username, this.password);
        }

        public T fromPasswordCredentials(PasswordCredentials in) {
            return ((Builder)this.username(in.getUsername())).password(in.getPassword());
        }
    }
}

