/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.functions.ReturnTrueOn404;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class ReturnEmptyPaginatedCollectionOnNotFoundOr404
implements Function<Exception, Object> {
    private final ReturnTrueOn404 rto404;

    @Inject
    private ReturnEmptyPaginatedCollectionOnNotFoundOr404(ReturnTrueOn404 rto404) {
        this.rto404 = (ReturnTrueOn404)Preconditions.checkNotNull((Object)rto404, (Object)"rto404");
    }

    public Object apply(Exception from) {
        Iterable throwables = Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)from), ResourceNotFoundException.class);
        if (Iterables.size((Iterable)throwables) >= 1) {
            return PaginatedCollection.EMPTY;
        }
        if (this.rto404.apply(from).booleanValue()) {
            return PaginatedCollection.EMPTY;
        }
        throw Throwables.propagate((Throwable)from);
    }
}

