/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.swift.domain.ObjectInfo;
import org.jclouds.openstack.swift.domain.internal.ObjectInfoImpl;
import org.jclouds.openstack.swift.options.ListContainerOptions;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class ParseObjectInfoListFromJsonResponse
extends ParseJson<PageSet<ObjectInfo>>
implements InvocationContext<ParseObjectInfoListFromJsonResponse> {
    private final Provider<UriBuilder> uriBuilders;
    private GeneratedHttpRequest request;
    private String container;

    @Inject
    public ParseObjectInfoListFromJsonResponse(Json json, Provider<UriBuilder> uriBuilders) {
        super(json, (TypeLiteral)new TypeLiteral<PageSet<ObjectInfo>>(){});
        this.uriBuilders = uriBuilders;
    }

    public PageSet<ObjectInfo> apply(InputStream stream) {
        Preconditions.checkState((this.request != null ? 1 : 0) != 0, (Object)"request should be initialized at this point");
        Preconditions.checkState((this.request.getArgs() != null ? 1 : 0) != 0, (Object)"request.getArgs() should be initialized at this point");
        Preconditions.checkArgument((boolean)(this.request.getArgs().get(0) instanceof String), (Object)"arg[0] must be a container name");
        Preconditions.checkArgument((boolean)(this.request.getArgs().get(1) instanceof ListContainerOptions[]), (Object)"arg[1] must be an array of ListContainerOptions");
        ListContainerOptions[] optionsList = (ListContainerOptions[])this.request.getArgs().get(1);
        ListContainerOptions options = optionsList.length > 0 ? optionsList[0] : ListContainerOptions.NONE;
        Type listType = new TypeToken<SortedSet<ObjectInfoImpl>>(){}.getType();
        try {
            SortedSet list = (SortedSet)this.apply(stream, listType);
            TreeSet returnVal = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)list, (Function)new Function<ObjectInfoImpl, ObjectInfo>(){

                public ObjectInfo apply(ObjectInfoImpl from) {
                    return ((ObjectInfoImpl.Builder)((ObjectInfoImpl.Builder)from.toBuilder().container(ParseObjectInfoListFromJsonResponse.this.container)).uri(((UriBuilder)ParseObjectInfoListFromJsonResponse.this.uriBuilders.get()).uri(ParseObjectInfoListFromJsonResponse.this.request.getEndpoint()).path(from.getName()).replaceQuery("").build(new Object[0]))).build();
                }
            }));
            boolean truncated = options.getMaxResults() == returnVal.size();
            String marker = truncated ? ((ObjectInfo)returnVal.last()).getName() : null;
            return new PageSetImpl((Iterable)returnVal, marker);
        }
        catch (IOException e) {
            throw new RuntimeException("problem reading response from request: " + this.request, e);
        }
    }

    public ParseObjectInfoListFromJsonResponse setContext(HttpRequest request) {
        Preconditions.checkArgument((boolean)(request instanceof GeneratedHttpRequest), (Object)"note this handler requires a GeneratedHttpRequest");
        this.request = (GeneratedHttpRequest)request;
        return this.setContainer(((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request)).getArgs().get(0).toString());
    }

    private ParseObjectInfoListFromJsonResponse setContainer(String container) {
        this.container = container;
        return this;
    }
}

