/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListContainerOptions
extends BaseHttpRequestOptions {
    public static final ListContainerOptions NONE = new ListContainerOptions();

    public ListContainerOptions afterMarker(String marker) {
        this.queryParameters.put((Object)"marker", Preconditions.checkNotNull((Object)marker, (Object)"marker"));
        return this;
    }

    public String getMarker() {
        return this.getFirstQueryOrNull("marker");
    }

    public ListContainerOptions maxResults(int limit) {
        Preconditions.checkState((limit >= 0 ? 1 : 0) != 0, (Object)"limit must be >= 0");
        Preconditions.checkState((limit <= 10000 ? 1 : 0) != 0, (Object)"limit must be <= 10000");
        this.queryParameters.put((Object)"limit", (Object)Integer.toString(limit));
        return this;
    }

    public int getMaxResults() {
        String val = this.getFirstQueryOrNull("limit");
        return val != null ? Integer.valueOf(val) : 10000;
    }

    public ListContainerOptions withPrefix(String prefix) {
        this.queryParameters.put((Object)"prefix", Preconditions.checkNotNull((Object)prefix, (Object)"prefix"));
        return this;
    }

    public String getPrefix() {
        return this.getFirstQueryOrNull("prefix");
    }

    public ListContainerOptions underPath(String path) {
        this.queryParameters.put((Object)"path", Preconditions.checkNotNull((Object)path, (Object)"path"));
        return this;
    }

    public String getPath() {
        return this.getFirstQueryOrNull("path");
    }

    public static class Builder {
        public static ListContainerOptions afterMarker(String marker) {
            ListContainerOptions options = new ListContainerOptions();
            return options.afterMarker(marker);
        }

        public static ListContainerOptions maxResults(int limit) {
            ListContainerOptions options = new ListContainerOptions();
            return options.maxResults(limit);
        }

        public static ListContainerOptions withPrefix(String prefix) {
            ListContainerOptions options = new ListContainerOptions();
            return options.withPrefix(prefix);
        }

        public static ListContainerOptions underPath(String path) {
            ListContainerOptions options = new ListContainerOptions();
            return options.underPath(path);
        }
    }
}

