/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.handlers;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.io.PayloadEnclosing;

public class AWSClientErrorRetryHandler
implements HttpRetryHandler {
    private final AWSUtils utils;
    private final BackoffLimitedRetryHandler backoffLimitedRetryHandler;

    @Inject
    public AWSClientErrorRetryHandler(AWSUtils utils, BackoffLimitedRetryHandler backoffLimitedRetryHandler) {
        this.utils = utils;
        this.backoffLimitedRetryHandler = backoffLimitedRetryHandler;
    }

    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        if ((response.getStatusCode() == 400 || response.getStatusCode() == 403 || response.getStatusCode() == 409) && response.getPayload() != null) {
            HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
            AWSError error = this.utils.parseAWSErrorFromContent(command.getCurrentRequest(), response);
            if (error != null && ImmutableSet.of((Object)"RequestTimeout", (Object)"OperationAborted", (Object)"SignatureDoesNotMatch").contains((Object)error.getCode())) {
                return this.backoffLimitedRetryHandler.shouldRetryRequest(command, response);
            }
        }
        return false;
    }
}

