/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.blobstore.LocalStorageStrategy;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.DateService;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.io.payloads.DelegatingPayload;

public class TransientStorageStrategy
implements LocalStorageStrategy {
    private final ConcurrentMap<String, ConcurrentMap<String, Blob>> containerToBlobs = new ConcurrentHashMap<String, ConcurrentMap<String, Blob>>();
    private final ConcurrentMap<String, Location> containerToLocation = new ConcurrentHashMap<String, Location>();
    private final Supplier<Location> defaultLocation;
    private final DateService dateService;
    private final Blob.Factory blobFactory;
    private final Crypto crypto;
    private final ContentMetadataCodec contentMetadataCodec;
    private final Provider<UriBuilder> uriBuilders;

    @Inject
    TransientStorageStrategy(Supplier<Location> defaultLocation, DateService dateService, Blob.Factory blobFactory, Crypto crypto, ContentMetadataCodec contentMetadataCodec, Provider<UriBuilder> uriBuilders) {
        this.defaultLocation = defaultLocation;
        this.dateService = dateService;
        this.blobFactory = blobFactory;
        this.crypto = crypto;
        this.contentMetadataCodec = contentMetadataCodec;
        this.uriBuilders = uriBuilders;
    }

    @Override
    public boolean containerExists(String containerName) {
        return this.containerToBlobs.containsKey(containerName);
    }

    @Override
    public Iterable<String> getAllContainerNames() {
        return this.containerToBlobs.keySet();
    }

    @Override
    public boolean createContainerInLocation(String containerName, Location location) {
        ConcurrentMap origValue = this.containerToBlobs.putIfAbsent(containerName, new ConcurrentHashMap());
        if (origValue != null) {
            return false;
        }
        this.containerToLocation.put(containerName, location != null ? location : (Location)this.defaultLocation.get());
        return true;
    }

    @Override
    public void deleteContainer(String containerName) {
        this.containerToBlobs.remove(containerName);
    }

    @Override
    public void clearContainer(String containerName) {
        this.clearContainer(containerName, ListContainerOptions.Builder.recursive());
    }

    @Override
    public void clearContainer(String containerName, ListContainerOptions options) {
        ((ConcurrentMap)this.containerToBlobs.get(containerName)).clear();
    }

    @Override
    public boolean blobExists(String containerName, String blobName) {
        Map map = (Map)this.containerToBlobs.get(containerName);
        return map != null && map.containsKey(blobName);
    }

    @Override
    public Iterable<String> getBlobKeysInsideContainer(String containerName) {
        return ((ConcurrentMap)this.containerToBlobs.get(containerName)).keySet();
    }

    @Override
    public Blob getBlob(String containerName, String blobName) {
        Map map = (Map)this.containerToBlobs.get(containerName);
        return map == null ? null : (Blob)map.get(blobName);
    }

    @Override
    public String putBlob(String containerName, Blob blob) throws IOException {
        Blob newBlob = this.createUpdatedCopyOfBlobInContainer(containerName, blob);
        Map map = (Map)this.containerToBlobs.get(containerName);
        map.put(newBlob.getMetadata().getName(), newBlob);
        Payloads.calculateMD5((PayloadEnclosing)newBlob, (MessageDigest)this.crypto.md5());
        String eTag = CryptoStreams.hex((byte[])newBlob.getPayload().getContentMetadata().getContentMD5());
        return eTag;
    }

    @Override
    public void removeBlob(String containerName, String blobName) {
        Map map = (Map)this.containerToBlobs.get(containerName);
        if (map != null) {
            map.remove(blobName);
        }
    }

    @Override
    public Location getLocation(String containerName) {
        return (Location)this.containerToLocation.get(containerName);
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    private Blob createUpdatedCopyOfBlobInContainer(String containerName, Blob in) {
        ByteArrayPayload payload;
        Preconditions.checkNotNull((Object)in, (Object)"blob");
        Preconditions.checkNotNull((Object)in.getPayload(), (Object)"blob.payload");
        ByteArrayPayload byteArrayPayload = payload = in.getPayload() instanceof ByteArrayPayload ? (ByteArrayPayload)ByteArrayPayload.class.cast(in.getPayload()) : null;
        if (payload == null) {
            payload = in.getPayload() instanceof DelegatingPayload ? (((DelegatingPayload)DelegatingPayload.class.cast(in.getPayload())).getDelegate() instanceof ByteArrayPayload ? (ByteArrayPayload)ByteArrayPayload.class.cast(((DelegatingPayload)DelegatingPayload.class.cast(in.getPayload())).getDelegate()) : null) : null;
        }
        try {
            if (payload == null || !(payload instanceof ByteArrayPayload)) {
                MutableContentMetadata oldMd = in.getPayload().getContentMetadata();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                in.getPayload().writeTo((OutputStream)out);
                payload = (ByteArrayPayload)Payloads.calculateMD5((Payload)Payloads.newPayload((Object)out.toByteArray()));
                HttpUtils.copy((ContentMetadata)oldMd, (MutableContentMetadata)payload.getContentMetadata());
            } else if (payload.getContentMetadata().getContentMD5() == null) {
                Payloads.calculateMD5((PayloadEnclosing)in, (MessageDigest)this.crypto.md5());
            }
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        Blob blob = this.blobFactory.create(BlobStoreUtils.copy(in.getMetadata()));
        blob.setPayload((Payload)payload);
        blob.getMetadata().setContainer(containerName);
        blob.getMetadata().setUri(((UriBuilder)this.uriBuilders.get()).scheme("mem").host(containerName).path(in.getMetadata().getName()).build(new Object[0]));
        blob.getMetadata().setLastModified(new Date());
        String eTag = CryptoStreams.hex((byte[])payload.getContentMetadata().getContentMD5());
        blob.getMetadata().setETag(eTag);
        blob.getAllHeaders().replaceValues((Object)"Last-Modified", Collections.singleton(this.dateService.rfc822DateFormat(blob.getMetadata().getLastModified())));
        blob.getAllHeaders().replaceValues((Object)"ETag", Collections.singleton(eTag));
        this.copyPayloadHeadersToBlob((Payload)payload, blob);
        blob.getAllHeaders().putAll((Multimap)Multimaps.forMap(blob.getMetadata().getUserMetadata()));
        return blob;
    }

    private void copyPayloadHeadersToBlob(Payload payload, Blob blob) {
        blob.getAllHeaders().putAll(this.contentMetadataCodec.toHeaders((ContentMetadata)payload.getContentMetadata()));
    }
}

