/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.internal.BlobRuntimeException;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ClearContainerStrategy;
import org.jclouds.blobstore.strategy.ClearListStrategy;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.logging.Logger;

@Singleton
public class DeleteAllKeysInList
implements ClearListStrategy,
ClearContainerStrategy {
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    protected final BackoffLimitedRetryHandler retryHandler;
    private final ExecutorService userExecutor;
    protected final AsyncBlobStore connection;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    DeleteAllKeysInList(@Named(value="jclouds.user-threads") ExecutorService userExecutor, AsyncBlobStore connection, BackoffLimitedRetryHandler retryHandler) {
        this.userExecutor = userExecutor;
        this.connection = connection;
        this.retryHandler = retryHandler;
    }

    @Override
    public void execute(String containerName) {
        this.execute(containerName, ListContainerOptions.Builder.recursive());
    }

    @Override
    public void execute(String containerName, ListContainerOptions options) {
        String message = options.getDir() != null ? String.format("clearing path %s/%s", containerName, options.getDir()) : String.format("clearing container %s", containerName);
        if ((options = options.clone()).isRecursive()) {
            message = message + " recursively";
        }
        Map exceptions = Maps.newHashMap();
        int maxErrors = 3;
        int i = 0;
        while (i < maxErrors) {
            PageSet listing;
            try {
                listing = (PageSet)this.connection.list(containerName, options).get();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (ExecutionException ee) {
                if (++i == maxErrors) {
                    throw Throwables.propagate((Throwable)ee.getCause());
                }
                this.retryHandler.imposeBackoffExponentialDelay(i, message);
                continue;
            }
            if (options.isRecursive()) {
                for (StorageMetadata md : listing) {
                    String fullPath = this.parentIsFolder(options, md) ? options.getDir() + "/" + md.getName() : md.getName();
                    switch (md.getType()) {
                        case BLOB: {
                            break;
                        }
                        case FOLDER: 
                        case RELATIVE_PATH: {
                            if (!options.isRecursive() || fullPath.equals(options.getDir())) break;
                            this.execute(containerName, options.clone().inDirectory(fullPath));
                            break;
                        }
                        case CONTAINER: {
                            throw new IllegalArgumentException("Container type not supported");
                        }
                    }
                }
            }
            HashMap responses = Maps.newHashMap();
            for (StorageMetadata md : listing) {
                String fullPath = this.parentIsFolder(options, md) ? options.getDir() + "/" + md.getName() : md.getName();
                switch (md.getType()) {
                    case BLOB: {
                        responses.put(md, this.connection.removeBlob(containerName, fullPath));
                        break;
                    }
                    case FOLDER: {
                        if (!options.isRecursive()) break;
                        responses.put(md, this.connection.deleteDirectory(containerName, fullPath));
                        break;
                    }
                    case RELATIVE_PATH: {
                        if (!options.isRecursive()) break;
                        responses.put(md, this.connection.deleteDirectory(containerName, md.getName()));
                        break;
                    }
                    case CONTAINER: {
                        throw new IllegalArgumentException("Container type not supported");
                    }
                }
            }
            exceptions = FutureIterables.awaitCompletion((Map)responses, (ExecutorService)this.userExecutor, (Long)this.maxTime, (Logger)this.logger, (String)message);
            if (!exceptions.isEmpty()) {
                this.retryHandler.imposeBackoffExponentialDelay(++i, message);
                continue;
            }
            String marker = listing.getNextMarker();
            if (marker == null) break;
            options = options.afterMarker(marker);
        }
        if (!exceptions.isEmpty()) {
            throw new BlobRuntimeException(String.format("error %s: %s", message, exceptions));
        }
    }

    private boolean parentIsFolder(ListContainerOptions options, StorageMetadata md) {
        return options.getDir() != null && md.getName().indexOf(47) == -1;
    }
}

