/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jeasy.props.annotations.Manageable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MBeanRegistrar {
    private static final String JMX_OBJECT_NAME_PREFIX = "org.jeasy.props:";
    private static final Logger LOGGER = LoggerFactory.getLogger(MBeanRegistrar.class);
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    MBeanRegistrar() {
    }

    void registerMBeanFor(Object object) {
        if (this.shouldBeManaged(object)) {
            Manageable manageable = object.getClass().getAnnotation(Manageable.class);
            String name = manageable.name().trim().isEmpty() ? object.getClass().getName() : manageable.name();
            try {
                ObjectName objectName = new ObjectName("org.jeasy.props:name=" + name);
                if (!this.mBeanServer.isRegistered(objectName)) {
                    this.mBeanServer.registerMBean(object, objectName);
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to register a JMX MBean for object '" + object + "'", (Throwable)e);
            }
        }
    }

    private boolean shouldBeManaged(Object object) {
        return object.getClass().isAnnotationPresent(Manageable.class);
    }
}

