/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props.processors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.jeasy.props.api.AnnotationProcessingException;
import org.jeasy.props.api.AnnotationProcessor;

public abstract class AbstractAnnotationProcessor<A extends Annotation>
implements AnnotationProcessor<A> {
    private static final String FILE_RESOURCE_PREFIX = "file:";
    private static final String CLASSPATH_RESOURCE_PREFIX = "classpath:";

    protected String missingAttributeValue(String attribute, String annotation, Field field) {
        return String.format("No value specified for attribute '%s' of annotation '%s' on field '%s' of type '%s' in class '%s'", attribute, annotation, field.getName(), field.getType().getName(), field.getDeclaringClass().getName());
    }

    protected void rejectIfEmpty(String value, String message) throws AnnotationProcessingException {
        if (value.isEmpty()) {
            throw new AnnotationProcessingException(message);
        }
    }

    InputStream getResourceAsStream(String resource) throws IOException {
        InputStream resourceAsStream = resource.startsWith(FILE_RESOURCE_PREFIX) ? new FileInputStream(this.extractPath(resource)) : (resource.startsWith(CLASSPATH_RESOURCE_PREFIX) ? Thread.currentThread().getContextClassLoader().getResourceAsStream(this.extractPath(resource)) : Thread.currentThread().getContextClassLoader().getResourceAsStream(resource));
        return resourceAsStream;
    }

    private String extractPath(String resource) {
        return resource.substring(resource.lastIndexOf(58) + 1);
    }
}

