/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props.processors;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jeasy.props.annotations.DBProperty;
import org.jeasy.props.api.AnnotationProcessingException;
import org.jeasy.props.processors.AbstractAnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBPropertyAnnotationProcessor
extends AbstractAnnotationProcessor<DBProperty> {
    public static final String DB_DRIVER = "org.jeasy.props.db.driver";
    public static final String DB_URL = "org.jeasy.props.db.url";
    public static final String DB_USER = "org.jeasy.props.db.user";
    public static final String DB_PASSWORD = "org.jeasy.props.db.password";
    public static final String DB_SCHEMA = "org.jeasy.props.db.schema";
    public static final String DB_TABLE = "org.jeasy.props.db.table";
    public static final String DB_TABLE_KEY_COLUMN = "org.jeasy.props.db.table.keyColumn";
    public static final String DB_TABLE_VALUE_COLUMN = "org.jeasy.props.db.table.valueColumn";
    private static final Logger LOGGER = LoggerFactory.getLogger(DBPropertyAnnotationProcessor.class);
    private final Map<String, Properties> dbConfigurationMap = new HashMap<String, Properties>();

    @Override
    public Object processAnnotation(DBProperty dbPropertyAnnotation, Field field) throws AnnotationProcessingException {
        Properties dbProperties;
        String value;
        String configuration = dbPropertyAnnotation.configuration().trim();
        String key = dbPropertyAnnotation.key().trim();
        String defaultValue = dbPropertyAnnotation.defaultValue().trim();
        boolean failFast = dbPropertyAnnotation.failFast();
        String annotationName = DBProperty.class.getName();
        this.rejectIfEmpty(configuration, this.missingAttributeValue("configuration", annotationName, field));
        this.rejectIfEmpty(key, this.missingAttributeValue("key", annotationName, field));
        if (!this.dbConfigurationMap.containsKey(configuration)) {
            this.loadDatabaseConfigurationProperties(configuration);
        }
        if ((value = (dbProperties = this.loadDatabaseProperties(configuration)).getProperty(key)) == null) {
            String message = String.format("Key '%s' not found in database configured with properties from file '%s'", key, configuration);
            LOGGER.warn(message);
            if (failFast) {
                throw new AnnotationProcessingException(message);
            }
            if (!defaultValue.isEmpty()) {
                value = defaultValue;
            }
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadDatabaseProperties(String configuration) throws AnnotationProcessingException {
        Properties properties;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Properties dbConfigurationProperties = this.dbConfigurationMap.get(configuration);
            Class.forName(dbConfigurationProperties.getProperty(DB_DRIVER));
            connection = this.getConnection(dbConfigurationProperties);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(this.getSqlQuery(dbConfigurationProperties));
            properties = this.extractProperties(resultSet, dbConfigurationProperties);
        }
        catch (Exception e) {
            try {
                throw new AnnotationProcessingException("Unable to get database properties from '" + configuration + "'", e);
            }
            catch (Throwable throwable) {
                try {
                    this.closeResources(connection, statement, resultSet);
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOGGER.warn("Unable to close database resources", (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            this.closeResources(connection, statement, resultSet);
            return properties;
        }
        catch (SQLException e) {
            LOGGER.warn("Unable to close database resources", (Throwable)e);
        }
        return properties;
    }

    private Properties extractProperties(ResultSet resultSet, Properties dbConfigurationProperties) throws SQLException {
        Properties dbProperties = new Properties();
        String keyColumn = dbConfigurationProperties.getProperty(DB_TABLE_KEY_COLUMN);
        String valueColumn = dbConfigurationProperties.getProperty(DB_TABLE_VALUE_COLUMN);
        while (resultSet.next()) {
            String dbKey = resultSet.getString(keyColumn);
            String dbValue = resultSet.getString(valueColumn);
            dbProperties.put(dbKey, dbValue);
        }
        return dbProperties;
    }

    private Connection getConnection(Properties dbConfigurationProperties) throws SQLException {
        String url = dbConfigurationProperties.getProperty(DB_URL);
        String user = dbConfigurationProperties.getProperty(DB_USER);
        String password = dbConfigurationProperties.getProperty(DB_PASSWORD);
        return DriverManager.getConnection(url, user, password);
    }

    private String getSqlQuery(Properties dbConfigurationProperties) {
        String schema = dbConfigurationProperties.getProperty(DB_SCHEMA);
        String table = dbConfigurationProperties.getProperty(DB_TABLE);
        String keyColumn = dbConfigurationProperties.getProperty(DB_TABLE_KEY_COLUMN);
        String valueColumn = dbConfigurationProperties.getProperty(DB_TABLE_VALUE_COLUMN);
        return String.format("SELECT %s, %s FROM %s.%s", keyColumn, valueColumn, schema, table);
    }

    private void closeResources(Connection connection, Statement statement, ResultSet resultSet) throws SQLException {
        if (resultSet != null) {
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (connection != null) {
            connection.close();
        }
    }

    private void loadDatabaseConfigurationProperties(String configuration) throws AnnotationProcessingException {
        Properties dbConfigurationProperties = new Properties();
        try {
            InputStream inputStream = this.getResourceAsStream(configuration);
            if (inputStream != null) {
                dbConfigurationProperties.load(inputStream);
                this.dbConfigurationMap.put(configuration, dbConfigurationProperties);
            }
        }
        catch (IOException e) {
            throw new AnnotationProcessingException(String.format("Unable to get properties from '%s'", configuration), e);
        }
    }
}

