/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props.processors;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.jeasy.props.annotations.ManifestProperty;
import org.jeasy.props.api.AnnotationProcessingException;
import org.jeasy.props.processors.AbstractAnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestPropertyAnnotationProcessor
extends AbstractAnnotationProcessor<ManifestProperty> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManifestPropertyAnnotationProcessor.class);
    private static final String CLASSPATH = System.getProperty("java.class.path");
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private final Map<String, Manifest> manifestEntries = new HashMap<String, Manifest>();

    @Override
    public Object processAnnotation(ManifestProperty manifestPropertyAnnotation, Field field) throws AnnotationProcessingException {
        String jar = manifestPropertyAnnotation.jar().trim();
        String header = manifestPropertyAnnotation.header().trim();
        String defaultValue = manifestPropertyAnnotation.defaultValue().trim();
        boolean failFast = manifestPropertyAnnotation.failFast();
        String annotationName = ManifestProperty.class.getName();
        this.rejectIfEmpty(jar, this.missingAttributeValue("jar", annotationName, field));
        this.rejectIfEmpty(header, this.missingAttributeValue("header", annotationName, field));
        if (this.manifestEntries.get(jar) == null) {
            this.loadManifestFromJar(jar);
        }
        this.rejectIfNotFound(jar);
        String value = this.manifestEntries.get(jar).getMainAttributes().getValue(header);
        if (value == null) {
            String message = String.format("Header '%s' not found in manifest of jar '%s'", header, jar);
            LOGGER.warn(message);
            if (failFast) {
                throw new AnnotationProcessingException(message);
            }
            if (!defaultValue.isEmpty()) {
                value = defaultValue;
            } else {
                return null;
            }
        }
        if (value.isEmpty()) {
            LOGGER.warn("Header '{}' in manifest of jar '{}' is empty", (Object)header, (Object)jar);
            return null;
        }
        return value;
    }

    private void rejectIfNotFound(String jar) throws AnnotationProcessingException {
        if (this.manifestEntries.get(jar) == null) {
            throw new AnnotationProcessingException(String.format("Unable to find jar '%s' in classpath '%s'", jar, CLASSPATH));
        }
    }

    private void loadManifestFromJar(String jar) throws AnnotationProcessingException {
        JarInputStream jarStream = null;
        try {
            String[] classPathElements;
            for (String element : classPathElements = CLASSPATH.split(PATH_SEPARATOR)) {
                if (!element.endsWith(jar)) continue;
                jarStream = new JarInputStream(new FileInputStream(element));
                this.manifestEntries.put(jar, jarStream.getManifest());
                break;
            }
        }
        catch (IOException e) {
            throw new AnnotationProcessingException(String.format("Unable to load manifest file from jar '%s'", jar), e);
        }
        finally {
            this.closeJarStream(jarStream);
        }
    }

    private void closeJarStream(JarInputStream jarStream) {
        try {
            if (jarStream != null) {
                jarStream.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to close jar stream", (Throwable)e);
        }
    }
}

