/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props.processors;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.jeasy.props.annotations.Properties;
import org.jeasy.props.api.AnnotationProcessingException;
import org.jeasy.props.processors.AbstractAnnotationProcessor;

public class PropertiesAnnotationProcessor
extends AbstractAnnotationProcessor<Properties> {
    private final Map<String, java.util.Properties> propertiesMap = new HashMap<String, java.util.Properties>();

    @Override
    public Object processAnnotation(Properties propertiesAnnotation, Field field) throws AnnotationProcessingException {
        this.rejectIfFieldIsNotOfType(field, java.util.Properties.class);
        String source = propertiesAnnotation.value().trim();
        String defaultSource = propertiesAnnotation.defaultValue().trim();
        boolean failFast = propertiesAnnotation.failFast();
        this.rejectIfEmpty(source, this.missingAttributeValue("source", Properties.class.getName(), field));
        if (this.propertiesMap.containsKey(source)) {
            return this.propertiesMap.get(source);
        }
        try {
            java.util.Properties properties = this.loadPropertiesFrom(source);
            this.propertiesMap.put(source, properties);
            return this.propertiesMap.get(source);
        }
        catch (Exception e) {
            if (failFast) {
                throw e;
            }
            if (!defaultSource.isEmpty()) {
                java.util.Properties properties = this.loadPropertiesFrom(defaultSource);
                this.propertiesMap.put(defaultSource, properties);
                return this.propertiesMap.get(defaultSource);
            }
            throw e;
        }
    }

    private java.util.Properties loadPropertiesFrom(String source) throws AnnotationProcessingException {
        java.util.Properties properties = new java.util.Properties();
        try {
            InputStream inputStream = this.getResourceAsStream(source);
            if (inputStream != null) {
                properties.load(inputStream);
                return properties;
            }
            throw new AnnotationProcessingException(String.format("Unable to load properties from source '%s'", source));
        }
        catch (IOException e) {
            throw new AnnotationProcessingException(String.format("Unable to load properties from source '%s'", source), e);
        }
    }

    private void rejectIfFieldIsNotOfType(Field field, Class<?> type) throws AnnotationProcessingException {
        if (!field.getType().equals(type)) {
            throw new AnnotationProcessingException(String.format("Annotation '%s' should be declared on fields of type '%s'", Properties.class.getName(), field.getType()));
        }
    }
}

