/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props.processors;

import java.lang.reflect.Field;
import org.jeasy.props.annotations.SystemProperty;
import org.jeasy.props.api.AnnotationProcessingException;
import org.jeasy.props.processors.AbstractAnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertyAnnotationProcessor
extends AbstractAnnotationProcessor<SystemProperty> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemPropertyAnnotationProcessor.class);

    @Override
    public Object processAnnotation(SystemProperty systemProperty, Field field) throws AnnotationProcessingException {
        String key = systemProperty.value().trim();
        String defaultValue = systemProperty.defaultValue();
        boolean failFast = systemProperty.failFast();
        this.rejectIfEmpty(key, this.missingAttributeValue("value", SystemProperty.class.getName(), field));
        String value = System.getProperty(key);
        if (value == null) {
            String message = String.format("System property '%s' on field '%s' of type '%s' in class '%s' not found in system properties", key, field.getName(), field.getType().getName(), field.getDeclaringClass().getName());
            LOGGER.warn(message);
            if (failFast) {
                throw new AnnotationProcessingException(message);
            }
            if (!defaultValue.isEmpty()) {
                value = defaultValue.trim();
            } else {
                LOGGER.warn("Default value of system property '{}' on field '{}' of type '{}' in class '{}' is empty", new Object[]{key, field.getName(), field.getType().getName(), field.getDeclaringClass().getName()});
                return null;
            }
        }
        return value;
    }
}

