/*
 * The MIT License
 *
 *   Copyright (c) 2020, Mahmoud Ben Hassine (mahmoud.benhassine@icloud.com)
 *
 *   Permission is hereby granted, free of charge, to any person obtaining a copy
 *   of this software and associated documentation files (the "Software"), to deal
 *   in the Software without restriction, including without limitation the rights
 *   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *   copies of the Software, and to permit persons to whom the Software is
 *   furnished to do so, subject to the following conditions:
 *
 *   The above copyright notice and this permission notice shall be included in
 *   all copies or substantial portions of the Software.
 *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *   THE SOFTWARE.
 */
package org.jeasy.random.randomizers.time;

import org.jeasy.random.api.Randomizer;

import java.util.Calendar;

/**
 * Generate a random {@link Calendar}.
 *
 * @author Mahmoud Ben Hassine (mahmoud.benhassine@icloud.com)
 */
public class CalendarRandomizer implements Randomizer<Calendar> {

    private final DateRandomizer delegate;

    /**
     * Create a new {@link CalendarRandomizer}.
     */
    public CalendarRandomizer() {
        delegate = new DateRandomizer();
    }

    /**
     * Create a new {@link CalendarRandomizer}.
     *
     * @param seed initial seed
     */
    public CalendarRandomizer(final long seed) {
        delegate = new DateRandomizer(seed);
    }

    /**
     * Create a new {@link CalendarRandomizer}.
     *
     * @return a new {@link CalendarRandomizer}.
     */
    public static CalendarRandomizer aNewCalendarRandomizer() {
        return new CalendarRandomizer();
    }

    /**
     * Create a new {@link CalendarRandomizer}.
     *
     * @param seed initial seed
     * @return a new {@link CalendarRandomizer}.
     */
    public static CalendarRandomizer aNewCalendarRandomizer(final long seed) {
        return new CalendarRandomizer(seed);
    }
    @Override
    public Calendar getRandomValue() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(delegate.getRandomValue());
        return calendar;
    }
}
