/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.configprovider;

import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ConfigDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigProvider
extends ConfigProvider
implements Saveable {
    protected final String ID_PREFIX = this.getClass().getSimpleName() + ".";
    protected Map<String, Config> configs = new HashMap<String, Config>();

    public AbstractConfigProvider() {
        this.load();
    }

    @Override
    public Collection<Config> getAllConfigs() {
        return Collections.unmodifiableCollection(this.configs.values());
    }

    @Override
    public Config getConfigById(String configId) {
        return this.configs.get(configId);
    }

    @Override
    public abstract ConfigDescription getConfigDescription();

    @Override
    public String getProviderId() {
        return this.ID_PREFIX;
    }

    @Override
    public boolean isResponsibleFor(String configId) {
        return configId != null && configId.startsWith(this.ID_PREFIX);
    }

    @Override
    public Config newConfig() {
        String id = this.getProviderId() + System.currentTimeMillis();
        return new Config(id, null, null, null);
    }

    @Override
    public void remove(String configId) {
        this.configs.remove(configId);
        this.save();
    }

    @Override
    public void save(Config config) {
        this.configs.put(config.id, config);
        this.save();
    }

    public void save() {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        try {
            this.getConfigXml().write((Object)this);
            SaveableListener.fireOnChange((Saveable)this, (XmlFile)this.getConfigXml());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void load() {
        XmlFile xml = this.getConfigXml();
        if (xml.exists()) {
            try {
                xml.unmarshal((Object)this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected XmlFile getConfigXml() {
        return new XmlFile(Jenkins.XSTREAM, new File(Jenkins.getInstance().getRootDir(), this.getXmlFileName()));
    }

    protected abstract String getXmlFileName();
}

