/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.io.mina;

import io.jenkins.cli.shaded.org.apache.mina.core.buffer.IoBuffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.Closeable;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.CloseFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.DefaultCloseFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.SshFutureListener;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.AbstractIoWriteFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoService;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoWriteFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.mina.MinaService;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.mina.MinaSupport;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.NumberUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable.IoBaseCloseable;
import java.net.SocketAddress;
import java.util.Objects;

public class MinaSession
extends AbstractInnerCloseable
implements IoSession {
    private final MinaService service;
    private final io.jenkins.cli.shaded.org.apache.mina.core.session.IoSession session;
    private final Object sessionWriteId;

    public MinaSession(MinaService service, io.jenkins.cli.shaded.org.apache.mina.core.session.IoSession session) {
        this.service = service;
        this.session = session;
        this.sessionWriteId = Objects.toString(session);
    }

    public io.jenkins.cli.shaded.org.apache.mina.core.session.IoSession getSession() {
        return this.session;
    }

    public void suspend() {
        this.session.suspendRead();
        this.session.suspendWrite();
    }

    @Override
    public Object getAttribute(Object key) {
        return this.session.getAttribute(key);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.session.setAttribute(key, value);
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    @Override
    public long getId() {
        return this.session.getId();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return new IoBaseCloseable(){
            private final DefaultCloseFuture future;
            {
                this.future = new DefaultCloseFuture(MinaSession.this.toString(), MinaSession.this.lock);
            }

            @Override
            public boolean isClosing() {
                return MinaSession.this.session.isClosing();
            }

            @Override
            public boolean isClosed() {
                return !MinaSession.this.session.isConnected();
            }

            @Override
            public void addCloseFutureListener(SshFutureListener<CloseFuture> listener) {
                this.future.addListener(listener);
            }

            @Override
            public void removeCloseFutureListener(SshFutureListener<CloseFuture> listener) {
                this.future.removeListener(listener);
            }

            @Override
            public CloseFuture close(boolean immediately) {
                io.jenkins.cli.shaded.org.apache.mina.core.future.CloseFuture cf = immediately ? MinaSession.this.session.closeNow() : MinaSession.this.session.closeOnFlush();
                cf.addListener(f -> this.future.setValue(Boolean.TRUE));
                return this.future;
            }
        };
    }

    public IoWriteFuture write(byte[] data) {
        return this.write(data, 0, NumberUtils.length(data));
    }

    public IoWriteFuture write(byte[] data, int offset, int len) {
        return this.write(IoBuffer.wrap((byte[])data, (int)offset, (int)len));
    }

    @Override
    public IoWriteFuture writePacket(Buffer buffer) {
        return this.write(MinaSupport.asIoBuffer(buffer));
    }

    public IoWriteFuture write(IoBuffer buffer) {
        Future future = new Future(this.sessionWriteId, null);
        this.session.write((Object)buffer).addListener(cf -> {
            Throwable t = cf.getException();
            if (t != null) {
                future.setException(t);
            } else {
                future.setWritten();
            }
        });
        return future;
    }

    @Override
    public IoService getService() {
        return this.service;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[local=" + this.session.getLocalAddress() + ", remote=" + this.session.getRemoteAddress() + "]";
    }

    public static class Future
    extends AbstractIoWriteFuture {
        public Future(Object id, Object lock) {
            super(id, lock);
        }

        public void setWritten() {
            this.setValue(Boolean.TRUE);
        }

        public void setException(Throwable exception) {
            this.setValue(Objects.requireNonNull(exception, "No exception specified"));
        }
    }
}

