/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.subsystem.sftp.extensions;

import io.jenkins.cli.shaded.org.apache.sshd.common.subsystem.sftp.extensions.AbstractParser;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class VersionsParser
extends AbstractParser<Versions> {
    public static final VersionsParser INSTANCE = new VersionsParser();

    public VersionsParser() {
        super("versions");
    }

    @Override
    public Versions parse(byte[] input, int offset, int len) {
        return this.parse(new String(input, offset, len, StandardCharsets.UTF_8));
    }

    public Versions parse(String value) {
        String[] comps = GenericUtils.split(value, ',');
        return new Versions(GenericUtils.isEmpty(comps) ? Collections.emptyList() : Arrays.asList(comps));
    }

    public static class Versions {
        public static final char SEP = ',';
        private List<String> versions;

        public Versions() {
            this(null);
        }

        public Versions(List<String> versions) {
            this.versions = versions;
        }

        public List<String> getVersions() {
            return this.versions;
        }

        public void setVersions(List<String> versions) {
            this.versions = versions;
        }

        public String toString() {
            return GenericUtils.join(this.getVersions(), ',');
        }
    }
}

