/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys;

import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;

@FunctionalInterface
public interface PublicKeyEntryResolver {
    public static final PublicKeyEntryResolver IGNORING = new PublicKeyEntryResolver(){

        @Override
        public PublicKey resolve(SessionContext session, String keyType, byte[] keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
            return null;
        }

        public String toString() {
            return "IGNORING";
        }
    };
    public static final PublicKeyEntryResolver FAILING = new PublicKeyEntryResolver(){

        @Override
        public PublicKey resolve(SessionContext session, String keyType, byte[] keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
            throw new InvalidKeySpecException("Failing resolver on key type=" + keyType);
        }

        public String toString() {
            return "FAILING";
        }
    };

    public PublicKey resolve(SessionContext var1, String var2, byte[] var3, Map<String, String> var4) throws IOException, GeneralSecurityException;
}

