/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.glassfish.tyrus.core.collection;

import io.jenkins.cli.shaded.org.glassfish.tyrus.core.collection.LazyValue;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.collection.Value;

public final class Values {
    private static final LazyValue EMPTY = new LazyValue(){

        @Override
        public Object get() {
            return null;
        }

        @Override
        public boolean isInitialized() {
            return true;
        }
    };

    private Values() {
    }

    public static <T> Value<T> empty() {
        return EMPTY;
    }

    public static <T> Value<T> of(T value) {
        return value == null ? Values.empty() : new InstanceValue<T>(value);
    }

    public static <T> LazyValue<T> lazy(Value<T> delegate) {
        return delegate == null ? EMPTY : new LazyValueImpl<T>(delegate);
    }

    public static <T> Value<T> eager(Value<T> delegate) {
        return delegate == null ? Values.empty() : new EagerValue<T>(delegate);
    }

    private static class LazyValueImpl<T>
    implements LazyValue<T> {
        private final Object lock;
        private final Value<T> delegate;
        private volatile Value<T> value;

        public LazyValueImpl(Value<T> delegate) {
            this.delegate = delegate;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            Value<T> result = this.value;
            if (result == null) {
                Object object = this.lock;
                synchronized (object) {
                    result = this.value;
                    if (result == null) {
                        result = Values.of(this.delegate.get());
                        this.value = result;
                    }
                }
            }
            return result.get();
        }

        @Override
        public boolean isInitialized() {
            return this.value != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.delegate.equals(((LazyValueImpl)o).delegate);
        }

        public int hashCode() {
            return this.delegate != null ? this.delegate.hashCode() : 0;
        }

        public String toString() {
            return "LazyValue{delegate=" + this.delegate.toString() + "}";
        }
    }

    private static class EagerValue<T>
    implements Value<T> {
        private final T result;

        private EagerValue(Value<T> value) {
            this.result = value.get();
        }

        @Override
        public T get() {
            return this.result;
        }
    }

    private static class InstanceValue<T>
    implements Value<T> {
        private final T value;

        public InstanceValue(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.value.equals(((InstanceValue)o).value);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public String toString() {
            return "InstanceValue{value=" + this.value + "}";
        }
    }
}

