/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.global;

import io.jenkins.cli.shaded.org.apache.sshd.common.channel.RequestHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.global.AbstractOpenSshHostKeysHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser;
import java.security.PublicKey;
import java.util.Collection;

public class OpenSshHostKeysHandler
extends AbstractOpenSshHostKeysHandler {
    public static final String REQUEST = "hostkeys-00@openssh.com";
    public static final OpenSshHostKeysHandler INSTANCE = new OpenSshHostKeysHandler();

    public OpenSshHostKeysHandler() {
        super(REQUEST);
        this.setIgnoreInvalidKeys(true);
    }

    public OpenSshHostKeysHandler(BufferPublicKeyParser<? extends PublicKey> parser) {
        super(REQUEST, parser);
        this.setIgnoreInvalidKeys(true);
    }

    @Override
    protected RequestHandler.Result handleHostKeys(Session session, Collection<? extends PublicKey> keys, boolean wantReply, Buffer buffer) throws Exception {
        ValidateUtils.checkTrue(!wantReply, "Unexpected reply required for the host keys of %s", (Object)session);
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleHostKeys({})[want-reply={}] received {} keys", session, wantReply, GenericUtils.size(keys));
        }
        return RequestHandler.Result.Replied;
    }
}

