/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.attachment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.Page;
import org.htmlunit.WebResponse;
import org.htmlunit.attachment.AttachmentHandler;
import org.htmlunit.util.StringUtils;

public class DownloadingAttachmentHandler
implements AttachmentHandler {
    private static final Log LOG = LogFactory.getLog(DownloadingAttachmentHandler.class);
    private Path downloadFolder_;

    public DownloadingAttachmentHandler(Path downloadFolder) throws IOException {
        this.downloadFolder_ = downloadFolder;
        if (Files.notExists(downloadFolder, new LinkOption[0])) {
            throw new IOException("The provided download folder '" + downloadFolder + "' does not exist");
        }
        if (!Files.isWritable(downloadFolder)) {
            throw new IOException("Can't write to the download folder '" + downloadFolder + "'");
        }
    }

    public DownloadingAttachmentHandler() throws IOException {
        this(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]));
    }

    @Override
    public void handleAttachment(Page page, String attachmentFilename) {
        Path destination = this.determineDestionationFile(page, attachmentFilename);
        WebResponse webResponse = page.getWebResponse();
        try (InputStream contentAsStream = webResponse.getContentAsStream();){
            FileUtils.copyToFile((InputStream)contentAsStream, (File)destination.toFile());
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to write attachment response content to '" + destination.toAbsolutePath() + "'"));
            return;
        }
        webResponse.cleanUp();
    }

    private Path determineDestionationFile(Page page, String attachmentFilename) {
        String fileName = attachmentFilename;
        if (StringUtils.isBlank(fileName)) {
            String file = page.getWebResponse().getWebRequest().getUrl().getFile();
            fileName = file.substring(file.lastIndexOf(47) + 1);
        }
        if (StringUtils.isBlank(fileName)) {
            fileName = "download";
        }
        Path newPath = this.downloadFolder_.resolve(fileName);
        int count = 1;
        while (Files.exists(newPath, LinkOption.NOFOLLOW_LINKS)) {
            int pos = fileName.lastIndexOf(46);
            String newFileName = pos == -1 ? fileName + "(" + count + ")" : fileName.substring(0, pos) + "(" + count + ")" + fileName.substring(pos);
            newPath = this.downloadFolder_.resolve(newFileName);
            ++count;
        }
        return newPath.toAbsolutePath();
    }
}

