/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.lc.type;

import java.util.Iterator;
import org.htmlunit.corejs.javascript.lc.type.ParameterizedTypeInfo;
import org.htmlunit.corejs.javascript.lc.type.TypeInfo;
import org.htmlunit.corejs.javascript.lc.type.impl.ClassSignatureFormatContext;

public interface TypeFormatContext {
    public static final TypeFormatContext DEFAULT = Class::getName;
    public static final TypeFormatContext SIMPLE = Class::getSimpleName;
    public static final TypeFormatContext CLASS_SIG = new ClassSignatureFormatContext();

    public String getClassName(Class<?> var1);

    default public void appendSpace(StringBuilder builder) {
        builder.append(' ');
    }

    default public void formatArray(StringBuilder builder, TypeInfo arrayType) {
        arrayType.getComponentType().append(this, builder);
        builder.append('[').append(']');
    }

    default public void formatParameterized(StringBuilder builder, ParameterizedTypeInfo type) {
        type.rawType().append(this, builder);
        builder.append('<');
        Iterator<TypeInfo> iterator = type.params().iterator();
        if (iterator.hasNext()) {
            iterator.next().append(this, builder);
            while (iterator.hasNext()) {
                builder.append(',');
                this.appendSpace(builder);
                iterator.next().append(this, builder);
            }
        }
        builder.append('>');
    }

    default public String getFormattedNone() {
        return "?";
    }
}

