/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebClient;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;

public class HtmlEmbed
extends HtmlElement {
    public static final String TAG_NAME = "embed";

    HtmlEmbed(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public void saveAs(File file) throws IOException {
        HtmlPage page = (HtmlPage)this.getPage();
        WebClient webclient = page.getWebClient();
        URL url = page.getFullyQualifiedUrl(this.getAttributeDirect("src"));
        WebRequest request = new WebRequest(url, page.getCharset(), page.getUrl());
        WebResponse webResponse = webclient.loadWebResponse(request);
        try (OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);
             InputStream content = webResponse.getContentAsStream();){
            IOUtils.copy((InputStream)content, (OutputStream)fos);
        }
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }
}

