/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.LabelableElement;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.StringUtils;

public class HtmlSubmitInput
extends HtmlInput
implements LabelableElement {
    public static final String DEFAULT_VALUE = "Submit Query";

    HtmlSubmitInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlForm form;
        if (!this.isDisabled() && (form = this.getEnclosingForm()) != null) {
            form.submit(this);
            return false;
        }
        super.doClickStateUpdate(shiftKey, ctrlKey);
        return false;
    }

    @Override
    public void setValue(String newValue) {
        this.unmarkValueDirty();
        this.setDefaultValue(newValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void reset() {
    }

    @Override
    protected void printOpeningTagContentAsXml(PrintWriter printWriter) {
        printWriter.print(this.getTagName());
        for (DomAttr attribute : this.getAttributesMap().values()) {
            String name = attribute.getNodeName();
            String value = attribute.getValue();
            if ("value".equals(name) && DEFAULT_VALUE.equals(value)) continue;
            printWriter.print(" ");
            printWriter.print(name);
            printWriter.print("=\"");
            printWriter.print(StringUtils.escapeXmlAttributeValue(value));
            printWriter.print("\"");
        }
    }

    @Override
    public NameValuePair[] getSubmitNameValuePairs() {
        if (!this.getNameAttribute().isEmpty() && !this.hasAttribute("value")) {
            return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), DEFAULT_VALUE)};
        }
        return super.getSubmitNameValuePairs();
    }

    @Override
    protected boolean isRequiredSupported() {
        return false;
    }
}

