/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.http;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.htmlunit.util.NameValuePair;

public final class HttpUtils {
    private static final BitSet URLENCODER;
    private static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final DateTimeFormatter FORMATTER_RFC1123;
    public static final String PATTERN_RFC1036 = "EEE, dd-MMM-yy HH:mm:ss zzz";
    private static final DateTimeFormatter FORMATTER_RFC1036;
    private static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final DateTimeFormatter FORMATTER_ASCTIME;
    private static final DateTimeFormatter[] STANDARD_PATTERNS;
    private static final ZoneId GMT_ID;

    public static Date parseDate(String dateValue) {
        if (dateValue == null) {
            return null;
        }
        String v = dateValue;
        if (v.length() > 1 && v.startsWith("'") && v.endsWith("'")) {
            v = v.substring(1, v.length() - 1);
        }
        for (DateTimeFormatter dateFormatter : STANDARD_PATTERNS) {
            try {
                return new Date(Instant.from(dateFormatter.parse(v)).toEpochMilli());
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    public static String formatDate(Date date) {
        Instant instant = Instant.ofEpochMilli(date.getTime());
        return FORMATTER_RFC1123.format(instant.atZone(GMT_ID));
    }

    public static List<NameValuePair> parseUrlQuery(String s, Charset charset) {
        if (s == null) {
            return new ArrayList<NameValuePair>(0);
        }
        BitSet delimSet = new BitSet();
        delimSet.set(38);
        delimSet.set(59);
        ParseRange cursor = new ParseRange(0, s.length());
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            delimSet.set(61);
            String name = HttpUtils.parseToken(s, cursor, delimSet);
            String value = null;
            if (!cursor.atEnd()) {
                char delim = s.charAt(cursor.getPos());
                cursor.updatePos(cursor.getPos() + 1);
                if (delim == '=') {
                    delimSet.clear(61);
                    value = HttpUtils.parseToken(s, cursor, delimSet);
                    if (!cursor.atEnd()) {
                        cursor.updatePos(cursor.getPos() + 1);
                    }
                }
            }
            if (name.isEmpty()) continue;
            list.add(new NameValuePair(HttpUtils.decodeFormFields(name, charset), HttpUtils.decodeFormFields(value, charset)));
        }
        return list;
    }

    private static String decodeFormFields(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        ByteBuffer bb = ByteBuffer.allocate(content.length());
        CharBuffer cb = CharBuffer.wrap(content);
        while (cb.hasRemaining()) {
            char c = cb.get();
            if (c == '%' && cb.remaining() >= 2) {
                char uc = cb.get();
                char lc = cb.get();
                int u = Character.digit(uc, 16);
                int l = Character.digit(lc, 16);
                if (u != -1 && l != -1) {
                    bb.put((byte)((u << 4) + l));
                    continue;
                }
                bb.put((byte)37);
                bb.put((byte)uc);
                bb.put((byte)lc);
                continue;
            }
            if (c == '+') {
                bb.put((byte)32);
                continue;
            }
            bb.put((byte)c);
        }
        bb.flip();
        return charset.decode(bb).toString();
    }

    public static String toQueryFormFields(Iterable<? extends NameValuePair> parameters, Charset charset) {
        StringBuilder result = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            String encodedName = HttpUtils.encodeFormFields(nameValuePair.getName(), charset);
            String encodedValue = HttpUtils.encodeFormFields(nameValuePair.getValue(), charset);
            if (result.length() > 0) {
                result.append('&');
            }
            result.append(encodedName);
            if (encodedValue == null) continue;
            result.append('=').append(encodedValue);
        }
        return result.toString();
    }

    private static String encodeFormFields(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        StringBuilder buf = new StringBuilder();
        ByteBuffer bb = charset.encode(content);
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (URLENCODER.get(b)) {
                buf.append((char)b);
                continue;
            }
            if (b == 32) {
                buf.append('+');
                continue;
            }
            buf.append('%');
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            buf.append(hex1).append(hex2);
        }
        return buf.toString();
    }

    private HttpUtils() {
    }

    private static String parseToken(String buf, ParseRange range, BitSet delimiters) {
        char current;
        StringBuilder dst = new StringBuilder();
        boolean whitespace = false;
        while (!range.atEnd() && !delimiters.get(current = buf.charAt(range.getPos()))) {
            if (HttpUtils.isWhitespace(current)) {
                HttpUtils.skipWhiteSpace(buf, range);
                whitespace = true;
                continue;
            }
            if (whitespace && dst.length() > 0) {
                dst.append(' ');
            }
            HttpUtils.copyContent(buf, range, delimiters, dst);
            whitespace = false;
        }
        return dst.toString();
    }

    private static void skipWhiteSpace(String buf, ParseRange range) {
        int pos = range.getPos();
        int indexTo = range.getUpperBound();
        for (int i = pos; i < indexTo && HttpUtils.isWhitespace(buf.charAt(i)); ++i) {
            ++pos;
        }
        range.updatePos(pos);
    }

    private static void copyContent(String buf, ParseRange range, BitSet delimiters, StringBuilder dst) {
        char current;
        int pos = range.getPos();
        int indexTo = range.getUpperBound();
        for (int i = pos; i < indexTo && !delimiters.get(current = buf.charAt(i)) && !HttpUtils.isWhitespace(current); ++i) {
            ++pos;
            dst.append(current);
        }
        range.updatePos(pos);
    }

    private static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    static {
        int i;
        URLENCODER = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            URLENCODER.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URLENCODER.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URLENCODER.set(i);
        }
        URLENCODER.set(95);
        URLENCODER.set(45);
        URLENCODER.set(46);
        URLENCODER.set(42);
        FORMATTER_RFC1123 = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(PATTERN_RFC1123).toFormatter(Locale.ENGLISH);
        FORMATTER_RFC1036 = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(PATTERN_RFC1036).toFormatter(Locale.ENGLISH);
        FORMATTER_ASCTIME = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(PATTERN_ASCTIME).toFormatter(Locale.ENGLISH);
        STANDARD_PATTERNS = new DateTimeFormatter[]{FORMATTER_RFC1123, FORMATTER_RFC1036, FORMATTER_ASCTIME};
        GMT_ID = ZoneId.of("GMT");
    }

    private static final class ParseRange {
        private final int upperBound_;
        private int pos_;

        ParseRange(int pos, int upperBound) {
            this.upperBound_ = upperBound;
            this.pos_ = pos;
        }

        int getPos() {
            return this.pos_;
        }

        int getUpperBound() {
            return this.upperBound_;
        }

        void updatePos(int pos) {
            this.pos_ = pos;
        }

        boolean atEnd() {
            return this.pos_ >= this.upperBound_;
        }
    }
}

