/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.MimeType;

@JsxClass
public class Plugin
extends HtmlUnitScriptable {
    private String description_;
    private String filename_;
    private String name_;
    private final List<MimeType> elements_ = new ArrayList<MimeType>();

    public Plugin() {
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    public Plugin(String name, String description, String filename) {
        this.name_ = name;
        this.description_ = description;
        this.filename_ = filename;
    }

    @JsxFunction
    public MimeType item(int index) {
        if (index >= 0 && index < this.elements_.size()) {
            return this.elements_.get(index);
        }
        return null;
    }

    @Override
    protected Object getWithPreemption(String name) {
        MimeType response = this.namedItem(name);
        if (response != null) {
            return response;
        }
        return NOT_FOUND;
    }

    @Override
    public final Object get(int index, Scriptable start) {
        Plugin plugin = (Plugin)start;
        List<MimeType> elements = plugin.elements_;
        if (index >= 0 && index < elements.size()) {
            return elements.get(index);
        }
        return NOT_FOUND;
    }

    @JsxFunction
    public MimeType namedItem(String name) {
        for (MimeType element : this.elements_) {
            if (!name.equals(element.getType())) continue;
            return element;
        }
        return null;
    }

    @JsxGetter
    public int getLength() {
        return this.elements_.size();
    }

    void add(MimeType element) {
        this.elements_.add(element);
    }

    @JsxGetter
    public String getDescription() {
        return this.description_;
    }

    @JsxGetter
    public String getFilename() {
        return this.filename_;
    }

    @JsxGetter
    public String getName() {
        return this.name_;
    }

    @JsxSymbol
    public Scriptable iterator() {
        return JavaScriptEngine.newArrayIteratorTypeValues(this.getParentScope(), this);
    }
}

