/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.css;

import hidden.jth.org.apache.commons.lang3.Strings;
import java.util.Locale;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.css.WrappedCssStyleDeclaration;
import org.htmlunit.cssparser.dom.CSSPageRuleImpl;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.css.CSSRule;
import org.htmlunit.javascript.host.css.CSSStyleDeclaration;
import org.htmlunit.javascript.host.css.CSSStyleSheet;
import org.w3c.dom.DOMException;

@JsxClass
public class CSSPageRule
extends CSSRule {
    public CSSPageRule() {
    }

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    protected CSSPageRule(CSSStyleSheet stylesheet, CSSPageRuleImpl rule) {
        super(stylesheet, rule);
    }

    @JsxGetter
    public String getSelectorText() {
        String selectorText = this.getPageRule().getSelectorText();
        if (selectorText != null) {
            return selectorText.toLowerCase(Locale.ROOT);
        }
        return null;
    }

    @JsxSetter
    public void setSelectorText(String selectorText) {
        try {
            this.getPageRule().setSelectorText(selectorText);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
    }

    @JsxGetter
    public CSSStyleDeclaration getStyle() {
        WrappedCssStyleDeclaration styleDeclaration = new WrappedCssStyleDeclaration(this.getPageRule().getStyle(), this.getBrowserVersion());
        return new CSSStyleDeclaration(this.getParentStyleSheet(), styleDeclaration);
    }

    private CSSPageRuleImpl getPageRule() {
        return (CSSPageRuleImpl)this.getRule();
    }

    @Override
    public String getCssText() {
        String cssText = super.getCssText();
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.CSS_CSSTEXT_FF_STYLE)) {
            cssText = Strings.CS.replace(cssText, "@page {", "@page  {");
        }
        return cssText;
    }
}

