/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.util.StringUtils;

@JsxClass
public final class DOMStringMap
extends HtmlUnitScriptable {
    public DOMStringMap() {
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    public DOMStringMap(Node node) {
        this.setDomNode(node.getDomNodeOrDie(), false);
        this.setParentScope(node.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @Override
    public Object get(String name, Scriptable start) {
        String value;
        HtmlElement e = (HtmlElement)this.getDomNodeOrNull();
        if (e != null && DomElement.ATTRIBUTE_NOT_DEFINED != (value = e.getAttribute("data-" + StringUtils.cssDeCamelize(name)))) {
            return value;
        }
        return NOT_FOUND;
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (!(ScriptableObject.getTopLevelScope(this) instanceof Window) || this.getWindow().getWebWindow() == null) {
            super.put(name, start, value);
        } else {
            HtmlElement e = (HtmlElement)this.getDomNodeOrNull();
            if (e != null) {
                e.setAttribute("data-" + StringUtils.cssDeCamelize(name), JavaScriptEngine.toString(value));
            }
        }
    }
}

