/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlArea;
import org.htmlunit.html.HtmlMap;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.html.HTMLCollection;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlMap.class)
public class HTMLMapElement
extends HTMLElement {
    private HTMLCollection areas_;

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxGetter
    public HTMLCollection getAreas() {
        if (this.areas_ == null) {
            HtmlMap map = (HtmlMap)this.getDomNodeOrDie();
            this.areas_ = new HTMLCollection((DomNode)map, false);
            this.areas_.setElementsSupplier((Supplier<List> & Serializable)() -> {
                ArrayList<DomNode> list = new ArrayList<DomNode>();
                for (DomNode domNode : map.getChildElements()) {
                    if (!(domNode instanceof HtmlArea)) continue;
                    list.add(domNode);
                }
                return list;
            });
        }
        return this.areas_;
    }

    @Override
    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getAttributeDirect("name");
    }

    @Override
    @JsxSetter
    public void setName(String name) {
        this.getDomNodeOrDie().setAttribute("name", name);
    }
}

