/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.html.HtmlMenu;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlMenu.class)
public class HTMLMenuElement
extends HTMLElement {
    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    protected String getType() {
        String type = this.getDomNodeOrDie().getAttributeDirect("type");
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MENU_TYPE_PASS)) {
            return type;
        }
        if ("context".equalsIgnoreCase(type)) {
            return "context";
        }
        if ("toolbar".equalsIgnoreCase(type)) {
            return "toolbar";
        }
        return "list";
    }

    protected void setType(String type) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MENU_TYPE_PASS)) {
            this.getDomNodeOrDie().setAttribute("type", type);
            return;
        }
        if ("context".equalsIgnoreCase(type)) {
            this.getDomNodeOrDie().setAttribute("type", "context");
            return;
        }
        if ("toolbar".equalsIgnoreCase(type)) {
            this.getDomNodeOrDie().setAttribute("type", "toolbar");
            return;
        }
        this.getDomNodeOrDie().setAttribute("type", "list");
    }

    @JsxGetter
    public boolean isCompact() {
        return this.getDomNodeOrDie().hasAttribute("compact");
    }

    @JsxSetter
    public void setCompact(Object compact) {
        if (JavaScriptEngine.toBoolean(compact)) {
            this.getDomNodeOrDie().setAttribute("compact", "");
        } else {
            this.getDomNodeOrDie().removeAttribute("compact");
        }
    }
}

