/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.worker;

import java.util.ArrayList;
import org.htmlunit.BrowserVersion;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.network.NetworkInformation;
import org.htmlunit.util.StringUtils;

@JsxClass
public class WorkerNavigator
extends HtmlUnitScriptable {
    private final BrowserVersion browserVersion_;

    public WorkerNavigator() {
        this.browserVersion_ = null;
    }

    WorkerNavigator(BrowserVersion browserVersion) {
        this.browserVersion_ = browserVersion;
    }

    @JsxConstructor
    public void jsConstructor() {
        throw JavaScriptEngine.typeErrorIllegalConstructor();
    }

    @Override
    public BrowserVersion getBrowserVersion() {
        return this.browserVersion_;
    }

    @JsxGetter
    public String getAppCodeName() {
        return this.getBrowserVersion().getApplicationCodeName();
    }

    @JsxGetter
    public String getAppName() {
        return this.getBrowserVersion().getApplicationName();
    }

    @JsxGetter
    public String getAppVersion() {
        return this.getBrowserVersion().getApplicationVersion();
    }

    @JsxGetter
    public String getLanguage() {
        return this.getBrowserVersion().getBrowserLanguage();
    }

    @JsxGetter
    public Scriptable getLanguages() {
        String[] parts;
        String acceptLang = this.getBrowserVersion().getAcceptLanguageHeader();
        if (StringUtils.isEmptyOrNull(acceptLang)) {
            return JavaScriptEngine.newArray((Scriptable)this, 0);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String part : parts = StringUtils.splitAtComma(acceptLang)) {
            if (StringUtils.isEmptyOrNull(part)) continue;
            String lang = hidden.jth.org.apache.commons.lang3.StringUtils.substringBefore(part, ";").trim();
            if (StringUtils.isEmptyOrNull(part)) continue;
            res.add(lang);
        }
        return JavaScriptEngine.newArray((Scriptable)this, res.toArray());
    }

    @JsxGetter
    public String getPlatform() {
        return this.getBrowserVersion().getPlatform();
    }

    @JsxGetter
    public String getProduct() {
        return "Gecko";
    }

    @JsxGetter
    public String getUserAgent() {
        return this.getBrowserVersion().getUserAgent();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public NetworkInformation getConnection() {
        NetworkInformation networkInformation = new NetworkInformation();
        networkInformation.setPrototype(this.getPrototype(networkInformation.getClass()));
        networkInformation.setParentScope(this.getParentScope());
        return networkInformation;
    }
}

