/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.xml;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.javascript.host.dom.Document;
import org.htmlunit.javascript.host.dom.DocumentFragment;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.util.StringUtils;
import org.w3c.dom.NamedNodeMap;

@JsxClass
public class XMLSerializer
extends HtmlUnitScriptable {
    private static final Set<String> NON_EMPTY_TAGS = new HashSet<String>(Arrays.asList("abbr", "acronym", "a", "address", "audio", "bdo", "big", "blockquote", "body", "b", "button", "canvas", "caption", "center", "cite", "code", "dfn", "dd", "del", "dir", "div", "dl", "dt", "embed", "em", "fieldset", "font", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "html", "iframe", "ins", "i", "kbd", "label", "legend", "listing", "li", "map", "marquee", "menu", "nobr", "noembed", "noframes", "noscript", "object", "ol", "optgroup", "option", "p", "plaintext", "pre", "q", "s", "samp", "script", "select", "small", "source", "span", "strike", "strong", "style", "sub", "sup", "title", "table", "col", "colgroup", "tbody", "td", "th", "tr", "textarea", "tfoot", "thead", "tt", "u", "ul", "var", "video", "wbr", "xmp"));

    @JsxConstructor
    public void jsConstructor() {
    }

    @JsxFunction
    public String serializeToString(Node root) {
        if (root == null) {
            return "";
        }
        if (root instanceof DocumentFragment) {
            Node node = root.getFirstChild();
            if (node == null) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            while (node != null) {
                builder.append(this.serializeToString(node));
                node = node.getNextSibling();
            }
            return builder.toString().trim();
        }
        boolean rootIsDocument = root instanceof Document;
        if (rootIsDocument) {
            root = ((Document)root).getDocumentElement();
        }
        if (root instanceof Element) {
            StringBuilder builder = new StringBuilder();
            DomNode node = root.getDomNodeOrDie();
            SgmlPage page = node.getPage();
            boolean isHtmlPage = page != null && page.isHtmlPage();
            String forcedNamespace = null;
            if (!rootIsDocument && isHtmlPage) {
                forcedNamespace = "http://www.w3.org/1999/xhtml";
            }
            this.toXml(1, node, builder, forcedNamespace);
            return builder.toString();
        }
        return root.getDomNodeOrDie().asXml();
    }

    private void toXml(int indent, DomNode node, StringBuilder builder, String foredNamespace) {
        String nodeName = node.getNodeName();
        builder.append('<').append(nodeName);
        String optionalPrefix = "";
        String namespaceURI = node.getNamespaceURI();
        String prefix = node.getPrefix();
        if (namespaceURI != null && prefix != null) {
            boolean sameNamespace = false;
            DomNode parentNode = node.getParentNode();
            while (parentNode instanceof DomElement) {
                if (namespaceURI.equals(parentNode.getNamespaceURI())) {
                    sameNamespace = true;
                    break;
                }
                parentNode = parentNode.getParentNode();
            }
            if (node.getParentNode() == null || !sameNamespace) {
                ((DomElement)node).setAttribute("xmlns:" + prefix, namespaceURI);
            }
        } else if (foredNamespace != null) {
            builder.append(" xmlns=\"").append(foredNamespace).append('\"');
            optionalPrefix = " ";
        }
        NamedNodeMap attributesMap = node.getAttributes();
        int lenght = attributesMap.getLength();
        for (int i = 0; i < lenght; ++i) {
            DomAttr attrib = (DomAttr)attributesMap.item(i);
            builder.append(' ').append(attrib.getQualifiedName()).append("=\"").append(attrib.getValue()).append('\"');
        }
        boolean startTagClosed = false;
        for (DomNode child : node.getChildren()) {
            if (!startTagClosed) {
                builder.append(optionalPrefix).append('>');
                startTagClosed = true;
            }
            switch (child.getNodeType()) {
                case 1: {
                    this.toXml(indent + 1, child, builder, null);
                    break;
                }
                case 3: {
                    String value = child.getNodeValue();
                    value = StringUtils.escapeXmlChars(value);
                    builder.append(value);
                    break;
                }
                case 4: 
                case 8: {
                    builder.append(child.asXml());
                    break;
                }
            }
        }
        if (!startTagClosed) {
            String tagName = StringUtils.toRootLowerCase(nodeName);
            if (NON_EMPTY_TAGS.contains(tagName)) {
                builder.append("></").append(nodeName).append('>');
            } else {
                builder.append(optionalPrefix).append("/>");
            }
        } else {
            builder.append("</").append(nodeName).append('>');
        }
    }
}

