/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util.brotli;

import java.nio.ByteBuffer;
import org.htmlunit.util.brotli.BrotliRuntimeException;
import org.htmlunit.util.brotli.Utils;

public final class Dictionary {
    static final int MIN_DICTIONARY_WORD_LENGTH = 4;
    static final int MAX_DICTIONARY_WORD_LENGTH = 31;
    private static ByteBuffer data = ByteBuffer.allocateDirect(0);
    static final int[] offsets = new int[32];
    static final int[] sizeBits = new int[32];
    private static final int DICTIONARY_DEBUG = Utils.isDebugMode();

    public static void setData(ByteBuffer newData, int[] newSizeBits) {
        int i;
        if (DICTIONARY_DEBUG != 0) {
            if (Utils.isDirect(newData) == 0 || Utils.isReadOnly(newData) == 0) {
                throw new BrotliRuntimeException("newData must be a direct read-only byte buffer");
            }
            if (newSizeBits.length > 31) {
                throw new BrotliRuntimeException("sizeBits length must be at most " + String.valueOf(31));
            }
            for (int i2 = 0; i2 < 4; ++i2) {
                if (newSizeBits[i2] == 0) continue;
                throw new BrotliRuntimeException("first " + String.valueOf(4) + " must be 0");
            }
        }
        int[] dictionaryOffsets = offsets;
        int[] dictionarySizeBits = sizeBits;
        for (int i3 = 0; i3 < newSizeBits.length; ++i3) {
            dictionarySizeBits[i3] = newSizeBits[i3];
        }
        int pos = 0;
        for (i = 0; i < newSizeBits.length; ++i) {
            dictionaryOffsets[i] = pos;
            int bits = dictionarySizeBits[i];
            if (bits == 0) continue;
            pos += i << (bits & 0x1F);
            if (DICTIONARY_DEBUG == 0) continue;
            if (bits >= 31) {
                throw new BrotliRuntimeException("newSizeBits values must be less than 31");
            }
            if (pos > 0 && pos <= newData.capacity()) continue;
            throw new BrotliRuntimeException("newSizeBits is inconsistent: overflow");
        }
        for (i = newSizeBits.length; i < 32; ++i) {
            dictionaryOffsets[i] = pos;
        }
        if (DICTIONARY_DEBUG != 0 && pos != newData.capacity()) {
            throw new BrotliRuntimeException("newSizeBits is inconsistent: underflow");
        }
        data = newData;
    }

    public static ByteBuffer getData() {
        if (data.capacity() != 0) {
            return data;
        }
        if (!DataLoader.OK) {
            throw new BrotliRuntimeException("brotli dictionary is not set");
        }
        return data;
    }

    private static class DataLoader {
        static final boolean OK;

        private DataLoader() {
        }

        static {
            boolean ok = true;
            try {
                Class.forName(Dictionary.class.getPackage().getName() + ".DictionaryData");
            }
            catch (Throwable ex) {
                ok = false;
            }
            OK = ok;
        }
    }
}

