/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import com.gargoylesoftware.htmlunit.HttpWebConnection;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import hudson.model.User;
import java.util.concurrent.Callable;
import jenkins.security.ApiTokenProperty;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.jvnet.hudson.test.HudsonTestCase;

public class ApiTokenPropertyTest
extends HudsonTestCase {
    public void testBasics() throws Exception {
        this.jenkins.setSecurityRealm(this.createDummySecurityRealm());
        User u = User.get((String)"foo");
        ApiTokenProperty t = (ApiTokenProperty)u.getProperty(ApiTokenProperty.class);
        final String token = t.getApiToken();
        HtmlPage config = this.createWebClient().goTo(u.getUrl() + "/configure");
        HtmlForm form = config.getFormByName("config");
        ApiTokenPropertyTest.assertEquals((String)token, (String)form.getInputByName("_.apiToken").getValueAttribute());
        this.submit(form);
        ApiTokenPropertyTest.assertSame((Object)t, (Object)u.getProperty(ApiTokenProperty.class));
        HudsonTestCase.WebClient wc = this.createWebClient();
        wc.setCredentialsProvider(new CredentialsProvider(){

            public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
                return new UsernamePasswordCredentials("foo", token);
            }
        });
        wc.setWebConnection((WebConnection)new HttpWebConnection(wc){

            protected HttpClient getHttpClient() {
                HttpClient c = super.getHttpClient();
                c.getParams().setAuthenticationPreemptive(true);
                c.getState().setCredentials(new AuthScope("localhost", ApiTokenPropertyTest.this.localPort, AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials("foo", token));
                return c;
            }
        });
        ApiTokenPropertyTest.assertEquals((Object)u, (Object)wc.executeOnServer(new Callable<User>(){

            @Override
            public User call() throws Exception {
                return User.current();
            }
        }));
    }
}

