/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.DefaultCssErrorHandler;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLHttpRequest;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import hudson.ClassicPluginStrategy;
import hudson.CloseProofOutputStream;
import hudson.DNSMultiCast;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.PluginManager;
import hudson.Util;
import hudson.WebAppMain;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.maven.MavenBuild;
import hudson.maven.MavenEmbedder;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenUtil;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DownloadService;
import hudson.model.Executor;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.RootAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.UpdateSite;
import hudson.model.View;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.remoting.Which;
import hudson.security.ACL;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.csrf.CrumbIssuer;
import hudson.slaves.CommandLauncher;
import hudson.slaves.ComputerConnector;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerListener;
import hudson.slaves.DumbSlave;
import hudson.slaves.RetentionStrategy;
import hudson.tasks.Ant;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Mailer;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import hudson.tools.ToolProperty;
import hudson.util.PersistedList;
import hudson.util.ReflectionUtils;
import hudson.util.StreamTaskListener;
import hudson.util.jna.GNUCLibrary;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.jar.Manifest;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsAdaptor;
import net.sf.json.JSONObject;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextFactory;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.debug.Debugger;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.matchers.JUnitMatchers;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.jvnet.hudson.test.ClosureExecuterAction;
import org.jvnet.hudson.test.FakeLauncher;
import org.jvnet.hudson.test.HudsonHomeLoader;
import org.jvnet.hudson.test.HudsonPageCreator;
import org.jvnet.hudson.test.HudsonTestCase;
import org.jvnet.hudson.test.JavaNetReverseProxy;
import org.jvnet.hudson.test.JenkinsComputerConnectorTester;
import org.jvnet.hudson.test.JenkinsRecipe;
import org.jvnet.hudson.test.LenientRunnable;
import org.jvnet.hudson.test.NoListenerConfiguration;
import org.jvnet.hudson.test.PretendSlave;
import org.jvnet.hudson.test.TestCrumbIssuer;
import org.jvnet.hudson.test.TestExtension;
import org.jvnet.hudson.test.TestPluginManager;
import org.jvnet.hudson.test.ThreadPoolImpl;
import org.jvnet.hudson.test.WarExploder;
import org.jvnet.hudson.test.WithoutJenkins;
import org.jvnet.hudson.test.rhino.JavaScriptDebugger;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.jetty.webapp.WebXmlConfiguration;
import org.mortbay.thread.ThreadPool;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.shell.Global;
import org.springframework.dao.DataAccessException;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenkinsRule
implements TestRule,
RootAction {
    private final TemporaryFolder tempFolder = new TemporaryFolder();
    private Description testDescription;
    private static JenkinsRule CURRENT = null;
    public Hudson hudson;
    public Jenkins jenkins;
    protected HudsonHomeLoader homeLoader = HudsonHomeLoader.NEW;
    protected int localPort;
    protected Server server;
    protected String contextPath = "";
    protected List<LenientRunnable> tearDowns = new ArrayList<LenientRunnable>();
    protected List<JenkinsRecipe.Runner> recipes = new ArrayList<JenkinsRecipe.Runner>();
    private List<WebClient> clients = new ArrayList<WebClient>();
    private List<Channel> channels = new ArrayList<Channel>();
    protected JavaScriptDebugger jsDebugger = new JavaScriptDebugger();
    public boolean useLocalPluginManager;
    private PluginManager pluginManager = TestPluginManager.INSTANCE;
    public JenkinsComputerConnectorTester computerConnectorTester = new JenkinsComputerConnectorTester(this);
    private static final Logger XML_HTTP_REQUEST_LOGGER = Logger.getLogger(XMLHttpRequest.class.getName());
    private static final Logger LOGGER;
    protected static final List<ToolProperty<?>> NO_PROPERTIES;
    public static int SLAVE_DEBUG_PORT;
    public static final MimeTypes MIME_TYPES;

    public Jenkins getInstance() {
        return this.jenkins;
    }

    protected void before() throws Throwable {
        this.recipe();
        AbstractProject.WORKSPACE.toString();
        hudson.model.User.clear();
        try {
            this.hudson = this.newHudson();
            this.jenkins = this.hudson;
        }
        catch (Exception e) {
            Field f = Jenkins.class.getDeclaredField("theInstance");
            f.setAccessible(true);
            f.set(null, null);
            throw e;
        }
        this.hudson.setNoUsageStatistics(Boolean.valueOf(true));
        this.hudson.setCrumbIssuer((CrumbIssuer)new TestCrumbIssuer());
        this.hudson.servletContext.setAttribute("app", (Object)this.hudson);
        this.hudson.servletContext.setAttribute("version", (Object)"?");
        WebAppMain.installExpressionFactory((ServletContextEvent)new ServletContextEvent(this.hudson.servletContext));
        this.hudson.getJDKs().add(new JDK("default", System.getProperty("java.home")));
        this.configureUpdateCenter();
        this.hudson.getActions().add(this);
        Mailer.DescriptorImpl desc = Mailer.descriptor();
        if (desc != null) {
            Mailer.descriptor().setHudsonUrl(null);
        }
        for (Descriptor d : this.hudson.getExtensionList(Descriptor.class)) {
            d.load();
        }
    }

    protected void configureUpdateCenter() throws Exception {
        String updateCenterUrl = "http://localhost:" + JavaNetReverseProxy.getInstance().localPort + "/update-center.json";
        DownloadService.neverUpdate = true;
        UpdateSite.neverUpdate = true;
        PersistedList sites = this.hudson.getUpdateCenter().getSites();
        sites.clear();
        sites.add((Object)new UpdateSite("default", updateCenterUrl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void after() {
        try {
            for (WebClient client : this.clients) {
                try {
                    client.getPage("about:blank");
                }
                catch (IOException e) {
                    // empty catch block
                }
                client.closeAllWindows();
            }
            this.clients.clear();
            for (Channel c : this.channels) {
                try {
                    c.close();
                }
                catch (IOException e) {}
            }
            for (Channel c : this.channels) {
                try {
                    c.join();
                }
                catch (InterruptedException e) {}
            }
            this.channels.clear();
        }
        catch (Throwable throwable) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                // empty catch block
            }
            Iterator<LenientRunnable> i$ = this.tearDowns.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    this.hudson.cleanUp();
                    ExtensionList.clearLegacyInstances();
                    DescriptorExtensionList.clearLegacyInstances();
                    System.gc();
                    throw throwable;
                }
                LenientRunnable r = i$.next();
                try {
                    r.run();
                }
                catch (Exception e) {}
            }
        }
        try {
            this.server.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator<Object> i$ = this.tearDowns.iterator();
        while (true) {
            if (!i$.hasNext()) {
                this.hudson.cleanUp();
                ExtensionList.clearLegacyInstances();
                DescriptorExtensionList.clearLegacyInstances();
                System.gc();
                return;
            }
            LenientRunnable r = (LenientRunnable)i$.next();
            try {
                r.run();
            }
            catch (Exception exception) {
            }
        }
    }

    public Statement apply(final Statement base, final Description description) {
        if (description.getAnnotation(WithoutJenkins.class) != null) {
            return this.tempFolder.apply(base, description);
        }
        return this.tempFolder.apply(new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                JenkinsRule.this.testDescription = description;
                Thread t = Thread.currentThread();
                String o = t.getName();
                t.setName("Executing " + JenkinsRule.this.testDescription.getDisplayName());
                CURRENT = JenkinsRule.this;
                JenkinsRule.this.before();
                try {
                    System.out.println("=== Starting " + JenkinsRule.this.testDescription.getDisplayName());
                    SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
                    try {
                        base.evaluate();
                    }
                    catch (Throwable th) {
                        try {
                            throw new BreakException();
                        }
                        catch (BreakException e) {
                            ThreadInfo[] threadInfos = Functions.getThreadInfos();
                            Functions.ThreadGroupMap m = Functions.sortThreadsAndGetGroupMap((ThreadInfo[])threadInfos);
                            for (ThreadInfo ti : threadInfos) {
                                System.err.println(Functions.dumpThreadInfo((ThreadInfo)ti, (Functions.ThreadGroupMap)m));
                            }
                            throw th;
                        }
                    }
                }
                finally {
                    JenkinsRule.this.after();
                    JenkinsRule.this.testDescription = null;
                    t.setName(o);
                    CURRENT = null;
                }
            }
        }, description);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "self";
    }

    protected Hudson newHudson() throws Exception {
        ServletContext webServer = this.createWebServer();
        File home = this.tempFolder.newFolder(new String[]{"jenkins-home-" + this.testDescription.getDisplayName()});
        for (JenkinsRecipe.Runner r : this.recipes) {
            r.decorateHome(this, home);
        }
        return new Hudson(home, webServer, this.getPluginManager());
    }

    public PluginManager getPluginManager() {
        if (this.hudson == null) {
            return this.useLocalPluginManager ? null : this.pluginManager;
        }
        return this.hudson.getPluginManager();
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.useLocalPluginManager = false;
        this.pluginManager = pluginManager;
        if (this.hudson != null) {
            throw new IllegalStateException("Too late to override the plugin manager");
        }
    }

    public JenkinsRule with(PluginManager pluginManager) {
        this.setPluginManager(pluginManager);
        return this;
    }

    public File getWebAppRoot() throws Exception {
        return WarExploder.getExplodedDir();
    }

    protected ServletContext createWebServer() throws Exception {
        this.server = new Server();
        WebAppContext context = new WebAppContext(WarExploder.getExplodedDir().getPath(), this.contextPath);
        context.setClassLoader(this.getClass().getClassLoader());
        context.setConfigurations(new Configuration[]{new WebXmlConfiguration(), new NoListenerConfiguration()});
        this.server.setHandler((Handler)context);
        context.setMimeTypes(MIME_TYPES);
        SocketConnector connector = new SocketConnector();
        connector.setHeaderBufferSize(12288);
        this.server.setThreadPool((ThreadPool)new ThreadPoolImpl(new ThreadPoolExecutor(10, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Jetty Thread Pool");
                return t;
            }
        })));
        this.server.addConnector((Connector)connector);
        this.server.addUserRealm(this.configureUserRealm());
        this.server.start();
        this.localPort = connector.getLocalPort();
        return context.getServletContext();
    }

    protected UserRealm configureUserRealm() {
        HashUserRealm realm = new HashUserRealm();
        realm.setName("default");
        realm.put((Object)"alice", (Object)"alice");
        realm.put((Object)"bob", (Object)"bob");
        realm.put((Object)"charlie", (Object)"charlie");
        realm.addUserToRole("alice", "female");
        realm.addUserToRole("bob", "male");
        realm.addUserToRole("charlie", "male");
        return realm;
    }

    protected Maven.MavenInstallation configureDefaultMaven() throws Exception {
        return this.configureDefaultMaven("apache-maven-2.2.1", 0);
    }

    protected Maven.MavenInstallation configureMaven3() throws Exception {
        Maven.MavenInstallation mvn = this.configureDefaultMaven("apache-maven-3.0.1", 2);
        Maven.MavenInstallation m3 = new Maven.MavenInstallation("apache-maven-3.0.1", mvn.getHome(), NO_PROPERTIES);
        ((Maven.DescriptorImpl)this.hudson.getDescriptorByType(Maven.DescriptorImpl.class)).setInstallations(new Maven.MavenInstallation[]{m3});
        return m3;
    }

    protected Maven.MavenInstallation configureDefaultMaven(String mavenVersion, int mavenReqVersion) throws Exception {
        Maven.MavenInstallation mavenInstallation;
        String buildDirectory = System.getProperty("buildDirectory", "./target/classes/");
        File mavenAlreadyInstalled = new File(buildDirectory, mavenVersion);
        if (mavenAlreadyInstalled.exists()) {
            Maven.MavenInstallation mavenInstallation2 = new Maven.MavenInstallation("default", mavenAlreadyInstalled.getAbsolutePath(), NO_PROPERTIES);
            ((Maven.DescriptorImpl)this.hudson.getDescriptorByType(Maven.DescriptorImpl.class)).setInstallations(new Maven.MavenInstallation[]{mavenInstallation2});
            return mavenInstallation2;
        }
        String home = System.getProperty("maven.home");
        if (home != null && (mavenInstallation = new Maven.MavenInstallation("default", home, NO_PROPERTIES)).meetsMavenReqVersion((Launcher)this.createLocalLauncher(), mavenReqVersion)) {
            ((Maven.DescriptorImpl)this.hudson.getDescriptorByType(Maven.DescriptorImpl.class)).setInstallations(new Maven.MavenInstallation[]{mavenInstallation});
            return mavenInstallation;
        }
        LOGGER.warning("Extracting a copy of Maven bundled in the test harness. To avoid a performance hit, set the system property 'maven.home' to point to a Maven2 installation.");
        FilePath mvn = this.hudson.getRootPath().createTempFile("maven", "zip");
        mvn.copyFrom(HudsonTestCase.class.getClassLoader().getResource(mavenVersion + "-bin.zip"));
        File mvnHome = new File(buildDirectory);
        mvn.unzip(new FilePath(mvnHome));
        if (!Functions.isWindows()) {
            GNUCLibrary.LIBC.chmod(new File(mvnHome, mavenVersion + "/bin/mvn").getPath(), 493);
        }
        Maven.MavenInstallation mavenInstallation3 = new Maven.MavenInstallation("default", new File(mvnHome, mavenVersion).getAbsolutePath(), NO_PROPERTIES);
        ((Maven.DescriptorImpl)this.hudson.getDescriptorByType(Maven.DescriptorImpl.class)).setInstallations(new Maven.MavenInstallation[]{mavenInstallation3});
        return mavenInstallation3;
    }

    protected Ant.AntInstallation configureDefaultAnt() throws Exception {
        Ant.AntInstallation antInstallation;
        if (System.getenv("ANT_HOME") != null) {
            antInstallation = new Ant.AntInstallation("default", System.getenv("ANT_HOME"), NO_PROPERTIES);
        } else {
            LOGGER.warning("Extracting a copy of Ant bundled in the test harness. To avoid a performance hit, set the environment variable ANT_HOME to point to an  Ant installation.");
            FilePath ant = this.hudson.getRootPath().createTempFile("ant", "zip");
            ant.copyFrom(HudsonTestCase.class.getClassLoader().getResource("apache-ant-1.8.1-bin.zip"));
            File antHome = this.createTmpDir();
            ant.unzip(new FilePath(antHome));
            if (!Functions.isWindows()) {
                GNUCLibrary.LIBC.chmod(new File(antHome, "apache-ant-1.8.1/bin/ant").getPath(), 493);
            }
            antInstallation = new Ant.AntInstallation("default", new File(antHome, "apache-ant-1.8.1").getAbsolutePath(), NO_PROPERTIES);
        }
        ((Ant.DescriptorImpl)this.hudson.getDescriptorByType(Ant.DescriptorImpl.class)).setInstallations(new Ant.AntInstallation[]{antInstallation});
        return antInstallation;
    }

    protected FreeStyleProject createFreeStyleProject() throws IOException {
        return this.createFreeStyleProject(this.createUniqueProjectName());
    }

    protected FreeStyleProject createFreeStyleProject(String name) throws IOException {
        return (FreeStyleProject)this.hudson.createProject(FreeStyleProject.class, name);
    }

    protected MatrixProject createMatrixProject() throws IOException {
        return this.createMatrixProject(this.createUniqueProjectName());
    }

    protected MatrixProject createMatrixProject(String name) throws IOException {
        return (MatrixProject)this.hudson.createProject(MatrixProject.class, name);
    }

    protected MavenModuleSet createMavenProject() throws IOException {
        return this.createMavenProject(this.createUniqueProjectName());
    }

    protected MavenModuleSet createMavenProject(String name) throws IOException {
        return (MavenModuleSet)this.hudson.createProject(MavenModuleSet.class, name);
    }

    private String createUniqueProjectName() {
        return "test" + this.hudson.getItems().size();
    }

    protected Launcher.LocalLauncher createLocalLauncher() {
        return new Launcher.LocalLauncher((TaskListener)StreamTaskListener.fromStdout());
    }

    public File createTmpDir() throws IOException {
        return this.tempFolder.newFolder(new String[]{"jenkins-" + this.testDescription.getDisplayName()});
    }

    public DumbSlave createSlave() throws Exception {
        return this.createSlave("", null);
    }

    public DumbSlave createSlave(Label l) throws Exception {
        return this.createSlave(l, null);
    }

    public SecurityRealm createDummySecurityRealm() {
        return new AbstractPasswordBasedSecurityRealm(){

            protected UserDetails authenticate(String username, String password) throws AuthenticationException {
                if (username.equals(password)) {
                    return this.loadUserByUsername(username);
                }
                throw new BadCredentialsException(username);
            }

            public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
                return new User(username, "", true, true, true, true, new GrantedAuthority[]{AUTHENTICATED_AUTHORITY});
            }

            public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
                throw new UsernameNotFoundException(groupname);
            }
        };
    }

    public URL getURL() throws IOException {
        return new URL("http://localhost:" + this.localPort + this.contextPath + "/");
    }

    public DumbSlave createSlave(EnvVars env) throws Exception {
        return this.createSlave("", env);
    }

    public DumbSlave createSlave(Label l, EnvVars env) throws Exception {
        return this.createSlave(l == null ? null : l.getExpression(), env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DumbSlave createSlave(String labels, EnvVars env) throws Exception {
        Hudson hudson = this.hudson;
        synchronized (hudson) {
            int sz = this.hudson.getNodes().size();
            return this.createSlave("slave" + sz, labels, env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DumbSlave createSlave(String nodeName, String labels, EnvVars env) throws Exception {
        Hudson hudson = this.hudson;
        synchronized (hudson) {
            DumbSlave slave = new DumbSlave(nodeName, "dummy", this.createTmpDir().getPath(), "1", Node.Mode.NORMAL, labels == null ? "" : labels, (ComputerLauncher)this.createComputerLauncher(env), RetentionStrategy.NOOP, Collections.EMPTY_LIST);
            this.hudson.addNode((hudson.model.Node)slave);
            return slave;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PretendSlave createPretendSlave(FakeLauncher faker) throws Exception {
        Hudson hudson = this.hudson;
        synchronized (hudson) {
            int sz = this.hudson.getNodes().size();
            PretendSlave slave = new PretendSlave("slave" + sz, this.createTmpDir().getPath(), "", (ComputerLauncher)this.createComputerLauncher(null), faker);
            this.hudson.addNode((hudson.model.Node)slave);
            return slave;
        }
    }

    public CommandLauncher createComputerLauncher(EnvVars env) throws URISyntaxException, MalformedURLException {
        int sz = this.hudson.getNodes().size();
        return new CommandLauncher(String.format("\"%s/bin/java\" %s -jar \"%s\"", System.getProperty("java.home"), SLAVE_DEBUG_PORT > 0 ? " -Xdebug -Xrunjdwp:transport=dt_socket,server=y,address=" + (SLAVE_DEBUG_PORT + sz) : "", new File(this.hudson.getJnlpJars("slave.jar").getURL().toURI()).getAbsolutePath()), env);
    }

    public DumbSlave createOnlineSlave() throws Exception {
        return this.createOnlineSlave(null);
    }

    public DumbSlave createOnlineSlave(Label l) throws Exception {
        return this.createOnlineSlave(l, null);
    }

    public DumbSlave createOnlineSlave(Label l, EnvVars env) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ComputerListener waiter = new ComputerListener(){

            public void onOnline(Computer C, TaskListener t) {
                latch.countDown();
                this.unregister();
            }
        };
        waiter.register();
        DumbSlave s = this.createSlave(l, env);
        latch.await();
        return s;
    }

    public void interactiveBreak() throws Exception {
        System.out.println("Jenkins is running at http://localhost:" + this.localPort + "/");
        new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    protected <T> T last(List<T> items) {
        return items.get(items.size() - 1);
    }

    protected void pause() throws IOException {
        new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    protected Page search(String q) throws Exception {
        return new WebClient().search(q);
    }

    protected void configRoundtrip() throws Exception {
        this.submit(this.createWebClient().goTo("configure").getFormByName("config"));
    }

    protected <P extends Job> P configRoundtrip(P job) throws Exception {
        this.submit(this.createWebClient().getPage((Item)job, "configure").getFormByName("config"));
        return job;
    }

    protected <P extends Item> P configRoundtrip(P job) throws Exception {
        this.submit(this.createWebClient().getPage(job, "configure").getFormByName("config"));
        return job;
    }

    protected <B extends Builder> B configRoundtrip(B before) throws Exception {
        FreeStyleProject p = this.createFreeStyleProject();
        p.getBuildersList().add(before);
        this.configRoundtrip(p);
        return (B)((Builder)p.getBuildersList().get(before.getClass()));
    }

    protected <P extends Publisher> P configRoundtrip(P before) throws Exception {
        FreeStyleProject p = this.createFreeStyleProject();
        p.getPublishersList().add(before);
        this.configRoundtrip(p);
        return (P)((Publisher)p.getPublishersList().get(before.getClass()));
    }

    protected <C extends ComputerConnector> C configRoundtrip(C before) throws Exception {
        this.computerConnectorTester.connector = before;
        this.submit(this.createWebClient().goTo("self/computerConnectorTester/configure").getFormByName("config"));
        return (C)this.computerConnectorTester.connector;
    }

    protected hudson.model.User configRoundtrip(hudson.model.User u) throws Exception {
        this.submit(this.createWebClient().goTo(u.getUrl() + "/configure").getFormByName("config"));
        return u;
    }

    protected <N extends hudson.model.Node> N configRoundtrip(N node) throws Exception {
        this.submit(this.createWebClient().goTo("/computer/" + node.getNodeName() + "/configure").getFormByName("config"));
        return (N)this.hudson.getNode(node.getNodeName());
    }

    protected <V extends View> V configRoundtrip(V view) throws Exception {
        this.submit(this.createWebClient().getPage(view, "configure").getFormByName("viewConfig"));
        return view;
    }

    public <R extends Run> R assertBuildStatus(Result status, R r) throws Exception {
        if (status == r.getResult()) {
            return r;
        }
        String msg = "unexpected build status; build log was:\n------\n" + JenkinsRule.getLog(r) + "\n------\n";
        if (r instanceof MatrixBuild) {
            MatrixBuild mb = (MatrixBuild)r;
            for (MatrixRun mr : mb.getRuns()) {
                msg = msg + "--- " + mr.getParent().getCombination() + " ---\n" + JenkinsRule.getLog((Run)mr) + "\n------\n";
            }
        }
        Assert.assertThat((String)msg, (Object)r.getResult(), (Matcher)Matchers.is((Object)status));
        return r;
    }

    public boolean isGoodHttpStatus(int status) {
        if (400 <= status && status <= 417) {
            return false;
        }
        return 500 > status || status > 505;
    }

    public void assertGoodStatus(Page page) {
        Assert.assertThat((Object)this.isGoodHttpStatus(page.getWebResponse().getStatusCode()), (Matcher)Matchers.is((Object)true));
    }

    public <R extends Run> R assertBuildStatusSuccess(R r) throws Exception {
        this.assertBuildStatus(Result.SUCCESS, r);
        return r;
    }

    public <R extends Run> R assertBuildStatusSuccess(Future<? extends R> r) throws Exception {
        Assert.assertThat((String)"build was actually scheduled", r, (Matcher)Matchers.notNullValue());
        return (R)this.assertBuildStatusSuccess((Run)r.get());
    }

    public <J extends AbstractProject<J, R>, R extends AbstractBuild<J, R>> R buildAndAssertSuccess(J job) throws Exception {
        return (R)((AbstractBuild)this.assertBuildStatusSuccess(job.scheduleBuild2(0)));
    }

    public FreeStyleBuild buildAndAssertSuccess(FreeStyleProject job) throws Exception {
        return (FreeStyleBuild)this.assertBuildStatusSuccess(job.scheduleBuild2(0));
    }

    public MavenModuleSetBuild buildAndAssertSuccess(MavenModuleSet job) throws Exception {
        return (MavenModuleSetBuild)this.assertBuildStatusSuccess(job.scheduleBuild2(0));
    }

    public MavenBuild buildAndAssertSuccess(MavenModule job) throws Exception {
        return (MavenBuild)this.assertBuildStatusSuccess(job.scheduleBuild2(0));
    }

    public void assertLogContains(String substring, Run run) throws Exception {
        Assert.assertThat((Object)JenkinsRule.getLog(run), (Matcher)JUnitMatchers.containsString((String)substring));
    }

    protected static String getLog(Run run) throws IOException {
        return Util.loadFile((File)run.getLogFile(), (Charset)run.getCharset());
    }

    public void assertXPath(HtmlPage page, String xpath) {
        Assert.assertThat((Object)page.getDocumentElement(), (Matcher)Matchers.hasXPath((String)xpath));
    }

    public void assertXPath(DomNode page, String xpath) {
        List nodes = page.getByXPath(xpath);
        Assert.assertThat((String)("There should be an object that matches XPath:" + xpath), (Object)nodes.isEmpty(), (Matcher)Matchers.is((Object)false));
    }

    public void assertXPathValue(DomNode page, String xpath, String expectedValue) {
        Node node = (Node)page.getFirstByXPath(xpath);
        Assert.assertThat((Object)node, (Matcher)Matchers.hasXPath((String)xpath, (Matcher)Matchers.is((Object)expectedValue)));
    }

    public void assertXPathValueContains(DomNode page, String xpath, String needle) {
        Node node = (Node)page.getFirstByXPath(xpath);
        Assert.assertThat((Object)node, (Matcher)Matchers.hasXPath((String)xpath, (Matcher)Matchers.containsString((String)needle)));
    }

    public void assertXPathResultsContainText(DomNode page, String xpath, String needle) {
        List nodes = page.getByXPath(xpath);
        Assert.assertThat((String)"no nodes matching xpath found", (Object)nodes.isEmpty(), (Matcher)Matchers.is((Object)false));
        boolean found = false;
        for (Object o : nodes) {
            Node n;
            String textString;
            if (!(o instanceof Node) || (textString = (n = (Node)o).getTextContent()) == null || !textString.contains(needle)) continue;
            found = true;
            break;
        }
        Assert.assertThat((String)"needle found in haystack", (Object)found, (Matcher)Matchers.is((Object)true));
    }

    public void assertAllImageLoadSuccessfully(HtmlPage p) {
        for (HtmlImage img : p.selectNodes("//IMG")) {
            try {
                img.getHeight();
            }
            catch (IOException e) {
                throw new Error("Failed to load " + img.getSrcAttribute(), e);
            }
        }
    }

    public void assertStringContains(String message, String haystack, String needle) {
        Assert.assertThat((String)message, (Object)haystack, (Matcher)Matchers.containsString((String)needle));
    }

    public void assertStringContains(String haystack, String needle) {
        Assert.assertThat((Object)haystack, (Matcher)Matchers.containsString((String)needle));
    }

    public void assertHelpExists(final Class<? extends Describable> type, final String properties) throws Exception {
        this.executeOnServer(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Descriptor d = JenkinsRule.this.hudson.getDescriptor(type);
                WebClient wc = JenkinsRule.this.createWebClient();
                for (String property : JenkinsRule.this.listProperties(properties)) {
                    String url = d.getHelpFile(property);
                    Assert.assertThat((String)("Help file for the property " + property + " is missing on " + type), (Object)url, (Matcher)Matchers.notNullValue());
                    wc.goTo(url);
                }
                return null;
            }
        });
    }

    private List<String> listProperties(String properties) {
        ArrayList<String> props = new ArrayList<String>(Arrays.asList(properties.split(",")));
        for (String p : props.toArray(new String[props.size()])) {
            if (!p.startsWith("-")) continue;
            props.remove(p);
            props.remove(p.substring(1));
        }
        return props;
    }

    public HtmlPage submit(HtmlForm form) throws Exception {
        return (HtmlPage)form.submit((SubmittableElement)((HtmlButton)this.last(form.getHtmlElementsByTagName("button"))));
    }

    public HtmlPage submit(HtmlForm form, String name) throws Exception {
        for (HtmlElement e : form.getHtmlElementsByTagName("button")) {
            HtmlElement p = (HtmlElement)e.getParentNode().getParentNode();
            if (!p.getAttribute("name").equals(name)) continue;
            ((HtmlButton)e).click();
            return (HtmlPage)form.submit((SubmittableElement)((HtmlButton)e));
        }
        throw new AssertionError((Object)("No such submit button with the name " + name));
    }

    protected HtmlInput findPreviousInputElement(HtmlElement current, String name) {
        return (HtmlInput)current.selectSingleNode("(preceding::input[@name='_." + name + "'])[last()]");
    }

    protected HtmlButton getButtonByCaption(HtmlForm f, String s) {
        for (HtmlElement b : f.getHtmlElementsByTagName("button")) {
            if (!b.getTextContent().trim().equals(s)) continue;
            return (HtmlButton)b;
        }
        return null;
    }

    public TaskListener createTaskListener() {
        return new StreamTaskListener((OutputStream)new CloseProofOutputStream((OutputStream)System.out));
    }

    public void assertEqualBeans(Object lhs, Object rhs, String properties) throws Exception {
        Assert.assertThat((String)"LHS", (Object)lhs, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"RHS", (Object)rhs, (Matcher)Matchers.notNullValue());
        for (String p : properties.split(",")) {
            Object rp;
            Object lp;
            PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)lhs, (String)p);
            if (pd == null) {
                try {
                    Field f = lhs.getClass().getField(p);
                    lp = f.get(lhs);
                    rp = f.get(rhs);
                }
                catch (NoSuchFieldException e) {
                    Assert.assertThat((String)("No such property " + p + " on " + lhs.getClass()), (Object)pd, (Matcher)Matchers.notNullValue());
                    return;
                }
            } else {
                lp = PropertyUtils.getProperty((Object)lhs, (String)p);
                rp = PropertyUtils.getProperty((Object)rhs, (String)p);
            }
            if (lp != null && rp != null && lp.getClass().isArray() && rp.getClass().isArray()) {
                int m = Array.getLength(lp);
                int n = Array.getLength(rp);
                Assert.assertThat((String)("Array length is different for property " + p), (Object)n, (Matcher)Matchers.is((Object)m));
                for (int i = 0; i < m; ++i) {
                    Assert.assertThat((String)(p + "[" + i + "] is different"), (Object)Array.get(rp, i), (Matcher)Matchers.is((Object)Array.get(lp, i)));
                }
                return;
            }
            Assert.assertThat((String)("Property " + p + " is different"), (Object)rp, (Matcher)Matchers.is((Object)lp));
        }
    }

    protected void setQuietPeriod(int qp) {
        JenkinsAdaptor.setQuietPeriod((Jenkins)this.hudson, qp);
    }

    public void assertEqualDataBoundBeans(Object lhs, Object rhs) throws Exception {
        if (lhs == null && rhs == null) {
            return;
        }
        if (lhs == null) {
            Assert.fail((String)("lhs is null while rhs=" + rhs));
        }
        if (rhs == null) {
            Assert.fail((String)("rhs is null while lhs=" + lhs));
        }
        Constructor<?> lc = this.findDataBoundConstructor(lhs.getClass());
        Constructor<?> rc = this.findDataBoundConstructor(rhs.getClass());
        Assert.assertThat((String)"Data bound constructor mismatch. Different type?", rc, (Matcher)Matchers.is(lc));
        ArrayList<String> primitiveProperties = new ArrayList<String>();
        String[] names = ClassDescriptor.loadParameterNames(lc);
        Class<?>[] types = lc.getParameterTypes();
        Assert.assertThat((Object)types.length, (Matcher)Matchers.is((Object)names.length));
        for (int i = 0; i < types.length; ++i) {
            Object lv = ReflectionUtils.getPublicProperty((Object)lhs, (String)names[i]);
            Object rv = ReflectionUtils.getPublicProperty((Object)rhs, (String)names[i]);
            if (Iterable.class.isAssignableFrom(types[i])) {
                Iterable lcol = (Iterable)lv;
                Iterable rcol = (Iterable)rv;
                Iterator ltr = lcol.iterator();
                Iterator rtr = rcol.iterator();
                while (ltr.hasNext() && rtr.hasNext()) {
                    Object litem = ltr.next();
                    Object ritem = rtr.next();
                    if (this.findDataBoundConstructor(litem.getClass()) != null) {
                        this.assertEqualDataBoundBeans(litem, ritem);
                        continue;
                    }
                    Assert.assertThat(ritem, (Matcher)Matchers.is(litem));
                }
                Assert.assertThat((String)("collection size mismatch between " + lhs + " and " + rhs), (Object)(ltr.hasNext() ^ rtr.hasNext()), (Matcher)Matchers.is((Object)false));
                continue;
            }
            if (this.findDataBoundConstructor(types[i]) != null || lv != null && this.findDataBoundConstructor(lv.getClass()) != null || rv != null && this.findDataBoundConstructor(rv.getClass()) != null) {
                this.assertEqualDataBoundBeans(lv, rv);
                continue;
            }
            primitiveProperties.add(names[i]);
        }
        if (!primitiveProperties.isEmpty()) {
            this.assertEqualBeans(lhs, rhs, Util.join(primitiveProperties, (String)","));
        }
    }

    public void assertEqualDataBoundBeans(List<?> lhs, List<?> rhs) throws Exception {
        Assert.assertThat((Object)rhs.size(), (Matcher)Matchers.is((Object)lhs.size()));
        for (int i = 0; i < lhs.size(); ++i) {
            this.assertEqualDataBoundBeans(lhs.get(i), rhs.get(i));
        }
    }

    protected Constructor<?> findDataBoundConstructor(Class<?> c) {
        for (Constructor<?> m : c.getConstructors()) {
            if (m.getAnnotation(DataBoundConstructor.class) == null) continue;
            return m;
        }
        return null;
    }

    protected <T extends Descriptor<?>> T get(Class<T> d) {
        return (T)this.hudson.getDescriptorByType(d);
    }

    protected boolean isSomethingHappening() {
        if (!this.hudson.getQueue().isEmpty()) {
            return true;
        }
        for (Computer n : this.hudson.getComputers()) {
            if (n.isIdle()) continue;
            return true;
        }
        return false;
    }

    protected void waitUntilNoActivity() throws Exception {
        this.waitUntilNoActivityUpTo(60000);
    }

    protected void waitUntilNoActivityUpTo(int timeout) throws Exception {
        long startTime = System.currentTimeMillis();
        int streak = 0;
        do {
            Thread.sleep(10L);
            streak = this.isSomethingHappening() ? 0 : ++streak;
            if (streak <= 5) continue;
            return;
        } while (System.currentTimeMillis() - startTime <= (long)timeout);
        ArrayList<Queue.Executable> building = new ArrayList<Queue.Executable>();
        for (Computer c : this.hudson.getComputers()) {
            for (Executor e : c.getExecutors()) {
                if (!e.isBusy()) continue;
                building.add(e.getCurrentExecutable());
            }
        }
        throw new AssertionError((Object)String.format("Hudson is still doing something after %dms: queue=%s building=%s", timeout, Arrays.asList(this.hudson.getQueue().getItems()), building));
    }

    protected void recipe() throws Exception {
        this.recipeLoadCurrentPlugin();
        try {
            for (final Annotation a : this.testDescription.getAnnotations()) {
                JenkinsRecipe r = a.annotationType().getAnnotation(JenkinsRecipe.class);
                if (r == null) continue;
                final JenkinsRecipe.Runner runner = r.value().newInstance();
                this.recipes.add(runner);
                this.tearDowns.add(new LenientRunnable(){

                    public void run() throws Exception {
                        runner.tearDown(JenkinsRule.this, a);
                    }
                });
                runner.setup(this, a);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected void recipeLoadCurrentPlugin() throws Exception {
        final Enumeration<URL> e = this.getClass().getClassLoader().getResources("the.hpl");
        if (!e.hasMoreElements()) {
            return;
        }
        URL hpl = e.nextElement();
        this.recipes.add(new JenkinsRecipe.Runner(){

            public void decorateHome(JenkinsRule testCase, File home) throws Exception {
                while (e.hasMoreElements()) {
                    URL hpl = (URL)e.nextElement();
                    Manifest m = new Manifest(hpl.openStream());
                    String shortName = m.getMainAttributes().getValue("Short-Name");
                    if (shortName == null) {
                        throw new Error(hpl + " doesn't have the Short-Name attribute");
                    }
                    FileUtils.copyURLToFile((URL)hpl, (File)new File(home, "plugins/" + shortName + ".hpl"));
                    String dependencies = m.getMainAttributes().getValue("Plugin-Dependencies");
                    if (dependencies == null) continue;
                    MavenEmbedder embedder = MavenUtil.createEmbedder((TaskListener)new StreamTaskListener((OutputStream)System.out, Charset.defaultCharset()), (File)null, null);
                    for (String dep : dependencies.split(",")) {
                        String[] tokens = dep.split(":");
                        String artifactId = tokens[0];
                        String version = tokens[1];
                        File dependencyJar = this.resolveDependencyJar(embedder, artifactId, version);
                        File dst = new File(home, "plugins/" + artifactId + ".hpi");
                        if (dst.exists() && dst.lastModified() == dependencyJar.lastModified()) continue;
                        FileUtils.copyFile((File)dependencyJar, (File)dst);
                    }
                }
            }

            private File resolveDependencyJar(MavenEmbedder embedder, String artifactId, String version) throws Exception {
                Enumeration<URL> manifests = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
                while (manifests.hasMoreElements()) {
                    URL manifest = manifests.nextElement();
                    InputStream is = manifest.openStream();
                    Manifest m = new Manifest(is);
                    is.close();
                    if (!artifactId.equals(m.getMainAttributes().getValue("Short-Name"))) continue;
                    return Which.jarFile((URL)manifest);
                }
                AbstractArtifactResolutionException resolutionError = null;
                for (String groupId : new String[]{"org.jvnet.hudson.plugins", "org.jvnet.hudson.main"}) {
                    URL dependencyPomResource = this.getClass().getResource("/META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
                    if (dependencyPomResource != null) {
                        return Which.jarFile((URL)dependencyPomResource);
                    }
                    Artifact a = embedder.createArtifact(groupId, artifactId, version, "compile", "hpi");
                    try {
                        embedder.resolve(a, Arrays.asList(embedder.createRepository("http://maven.glassfish.org/content/groups/public/", "repo")), embedder.getLocalRepository());
                        return a.getFile();
                    }
                    catch (AbstractArtifactResolutionException x) {
                        resolutionError = x;
                    }
                }
                throw new Exception("Failed to resolve plugin: " + artifactId + " version " + version, resolutionError);
            }
        });
    }

    public JenkinsRule withNewHome() {
        return this.with(HudsonHomeLoader.NEW);
    }

    public JenkinsRule withExistingHome(File source) throws Exception {
        return this.with(new HudsonHomeLoader.CopyExisting(source));
    }

    public JenkinsRule withPresetData(String name) {
        name = "/" + name + ".zip";
        URL res = this.getClass().getResource(name);
        if (res == null) {
            throw new IllegalArgumentException("No such data set found: " + name);
        }
        return this.with(new HudsonHomeLoader.CopyExisting(res));
    }

    public JenkinsRule with(HudsonHomeLoader homeLoader) {
        this.homeLoader = homeLoader;
        return this;
    }

    public <V> V executeOnServer(Callable<V> c) throws Exception {
        return this.createWebClient().executeOnServer(c);
    }

    private Object writeReplace() {
        throw new AssertionError((Object)("JenkinsRule " + this.testDescription.getDisplayName() + " is not supposed to be serialized"));
    }

    public WebClient createWebClient() {
        return new WebClient();
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
        Dispatcher.TRACE = true;
        MetaClass.NO_CACHE = true;
        File dir = new File("src/main/resources");
        if (dir.exists() && MetaClassLoader.debugLoader == null) {
            try {
                MetaClassLoader.debugLoader = new MetaClassLoader((ClassLoader)new URLClassLoader(new URL[]{dir.toURI().toURL()}));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        Logger.getLogger("org.springframework").setLevel(Level.WARNING);
        hudson.Main.isUnitTest = true;
        XML_HTTP_REQUEST_LOGGER.setFilter(new Filter(){

            public boolean isLoggable(LogRecord record) {
                return !record.getMessage().contains("XMLHttpRequest.getResponseHeader() was called before the response was available.");
            }
        });
        System.setProperty("org.mortbay.jetty.Request.maxFormContentSize", "-1");
        LOGGER = Logger.getLogger(HudsonTestCase.class.getName());
        NO_PROPERTIES = Collections.emptyList();
        SLAVE_DEBUG_PORT = Integer.getInteger(HudsonTestCase.class.getName() + ".slaveDebugPort", -1);
        MIME_TYPES = new MimeTypes();
        MIME_TYPES.addMimeMapping("js", "application/javascript");
        Functions.DEBUG_YUI = true;
        ClassicPluginStrategy.useAntClassLoader = true;
        DNSMultiCast.disabled = true;
        if (!Functions.isWindows()) {
            try {
                GNUCLibrary.LIBC.unsetenv("MAVEN_OPTS");
                GNUCLibrary.LIBC.unsetenv("MAVEN_DEBUG_OPTS");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to cancel out MAVEN_OPTS", e);
            }
        }
    }

    public static class TestBuildWrapper
    extends BuildWrapper {
        public Result buildResultInTearDown;

        public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
            return new BuildWrapper.Environment(){

                public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                    TestBuildWrapper.this.buildResultInTearDown = build.getResult();
                    return true;
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static class TestBuildWrapperDescriptor
        extends BuildWrapperDescriptor {
            public boolean isApplicable(AbstractProject<?, ?> project) {
                return true;
            }

            public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) {
                throw new UnsupportedOperationException();
            }

            public String getDisplayName() {
                return ((Object)((Object)this)).getClass().getName();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WebClient
    extends com.gargoylesoftware.htmlunit.WebClient {
        public WebClient() {
            super(BrowserVersion.FIREFOX_2);
            this.setPageCreator((PageCreator)HudsonPageCreator.INSTANCE);
            JenkinsRule.this.clients.add(this);
            this.setAjaxController(new AjaxController(){

                public boolean processSynchron(HtmlPage page, WebRequestSettings settings, boolean async) {
                    return false;
                }
            });
            this.setCssErrorHandler(new ErrorHandler(){
                final ErrorHandler defaultHandler = new DefaultCssErrorHandler();

                public void warning(CSSParseException exception) throws CSSException {
                    if (!this.ignore(exception)) {
                        this.defaultHandler.warning(exception);
                    }
                }

                public void error(CSSParseException exception) throws CSSException {
                    if (!this.ignore(exception)) {
                        this.defaultHandler.error(exception);
                    }
                }

                public void fatalError(CSSParseException exception) throws CSSException {
                    if (!this.ignore(exception)) {
                        this.defaultHandler.fatalError(exception);
                    }
                }

                private boolean ignore(CSSParseException e) {
                    return e.getURI().contains("/yui/");
                }
            });
            this.getJavaScriptEngine().getContextFactory().addListener(new ContextFactory.Listener(){

                public void contextCreated(Context cx) {
                    if (cx.getDebugger() == null) {
                        cx.setDebugger((Debugger)JenkinsRule.this.jsDebugger, null);
                    }
                }

                public void contextReleased(Context cx) {
                }
            });
            this.setTimeout(60000);
        }

        public WebClient login(String username, String password) throws Exception {
            HtmlPage page = this.goTo("/login");
            HtmlForm form = page.getFormByName("login");
            form.getInputByName("j_username").setValueAttribute(username);
            form.getInputByName("j_password").setValueAttribute(password);
            form.submit(null);
            return this;
        }

        public WebClient login(String username) throws Exception {
            this.login(username, username);
            return this;
        }

        public <V> V executeOnServer(final Callable<V> c) throws Exception {
            final Exception[] t = new Exception[1];
            final ArrayList r = new ArrayList(1);
            ClosureExecuterAction cea = (ClosureExecuterAction)JenkinsRule.this.hudson.getExtensionList(RootAction.class).get(ClosureExecuterAction.class);
            UUID id = UUID.randomUUID();
            cea.add(id, new Runnable(){

                public void run() {
                    try {
                        StaplerResponse rsp = Stapler.getCurrentResponse();
                        rsp.setStatus(200);
                        rsp.setContentType("text/html");
                        r.add(c.call());
                    }
                    catch (Exception e) {
                        t[0] = e;
                    }
                }
            });
            this.goTo("closures/?uuid=" + id);
            if (t[0] != null) {
                throw t[0];
            }
            return (V)r.get(0);
        }

        public HtmlPage search(String q) throws IOException, SAXException {
            HtmlPage top = this.goTo("");
            HtmlForm search = top.getFormByName("search");
            search.getInputByName("q").setValueAttribute(q);
            return (HtmlPage)search.submit(null);
        }

        public HtmlPage getPage(Run r) throws IOException, SAXException {
            return this.getPage(r, "");
        }

        public HtmlPage getPage(Run r, String relative) throws IOException, SAXException {
            return this.goTo(r.getUrl() + relative);
        }

        public HtmlPage getPage(Item item) throws IOException, SAXException {
            return this.getPage(item, "");
        }

        public HtmlPage getPage(Item item, String relative) throws IOException, SAXException {
            return this.goTo(item.getUrl() + relative);
        }

        public HtmlPage getPage(hudson.model.Node item) throws IOException, SAXException {
            return this.getPage(item, "");
        }

        public HtmlPage getPage(hudson.model.Node item, String relative) throws IOException, SAXException {
            return this.goTo(item.toComputer().getUrl() + relative);
        }

        public HtmlPage getPage(View view) throws IOException, SAXException {
            return this.goTo(view.getUrl());
        }

        public HtmlPage getPage(View view, String relative) throws IOException, SAXException {
            return this.goTo(view.getUrl() + relative);
        }

        public Page getPage(String url) throws IOException, FailingHttpStatusCodeException {
            return super.getPage(url);
        }

        public HtmlPage goTo(String relative) throws IOException, SAXException {
            Page p = this.goTo(relative, "text/html");
            if (p instanceof HtmlPage) {
                return (HtmlPage)p;
            }
            throw new AssertionError((Object)("Expected text/html but instead the content type was " + p.getWebResponse().getContentType()));
        }

        public Page goTo(String relative, String expectedContentType) throws IOException, SAXException {
            Page p = super.getPage(this.getContextPath() + relative);
            Assert.assertThat((Object)p.getWebResponse().getContentType(), (Matcher)Matchers.is((Object)expectedContentType));
            return p;
        }

        public XmlPage goToXml(String path) throws IOException, SAXException {
            Page page = this.goTo(path, "application/xml");
            if (page instanceof XmlPage) {
                return (XmlPage)page;
            }
            return null;
        }

        public String getContextPath() throws IOException {
            return JenkinsRule.this.getURL().toExternalForm();
        }

        public WebRequestSettings addCrumb(WebRequestSettings req) {
            NameValuePair[] crumb = new NameValuePair[]{new NameValuePair()};
            crumb[0].setName(JenkinsRule.this.hudson.getCrumbIssuer().getDescriptor().getCrumbRequestField());
            crumb[0].setValue(JenkinsRule.this.hudson.getCrumbIssuer().getCrumb(null));
            req.setRequestParameters(Arrays.asList(crumb));
            return req;
        }

        public URL createCrumbedUrl(String relativePath) throws IOException {
            CrumbIssuer issuer = JenkinsRule.this.hudson.getCrumbIssuer();
            String crumbName = issuer.getDescriptor().getCrumbRequestField();
            String crumb = issuer.getCrumb(null);
            return new URL(this.getContextPath() + relativePath + "?" + crumbName + "=" + crumb);
        }

        public HtmlPage eval(Runnable requestHandler) throws IOException, SAXException {
            ClosureExecuterAction cea = (ClosureExecuterAction)JenkinsRule.this.hudson.getExtensionList(RootAction.class).get(ClosureExecuterAction.class);
            UUID id = UUID.randomUUID();
            cea.add(id, requestHandler);
            return this.goTo("closures/?uuid=" + id);
        }

        public Dim interactiveJavaScriptDebugger() {
            Global global = new Global();
            HtmlUnitContextFactory cf = this.getJavaScriptEngine().getContextFactory();
            global.init((ContextFactory)cf);
            Dim dim = Main.mainEmbedded((ContextFactory)cf, (Scriptable)global, (String)("Rhino debugger: " + JenkinsRule.this.testDescription.getDisplayName()));
            dim.setBreakOnExceptions(true);
            return dim;
        }
    }

    @TestExtension
    public static class ComputerListenerImpl
    extends ComputerListener {
        public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
            VirtualChannel ch = c.getChannel();
            if (ch instanceof Channel) {
                CURRENT.channels.add((Channel)ch);
            }
        }
    }

    public static class BreakException
    extends Exception {
    }
}

