/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.Extension;
import hudson.ExtensionFinder;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jvnet.hudson.test.TestEnvironment;
import org.jvnet.hudson.test.TestExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class TestExtensionLoader
extends ExtensionFinder.AbstractGuiceFinder<TestExtension> {
    public TestExtensionLoader() {
        super(TestExtension.class);
    }

    protected boolean isOptional(TestExtension annotation) {
        return false;
    }

    protected double getOrdinal(TestExtension annotation) {
        return 0.0;
    }

    protected boolean isActive(AnnotatedElement e) {
        TestEnvironment env = TestEnvironment.get();
        TestExtension a = e.getAnnotation(TestExtension.class);
        if (a == null) {
            return false;
        }
        String testName = a.value();
        if (testName.length() > 0 && !env.testCase.getName().equals(testName)) {
            return false;
        }
        if (e instanceof Class) {
            return this.isActive(env, (Class)e);
        }
        if (e instanceof Field) {
            Field f = (Field)e;
            return f.getDeclaringClass().isInstance((Object)env.testCase);
        }
        if (e instanceof Method) {
            Method m = (Method)e;
            return m.getDeclaringClass().isInstance((Object)env.testCase);
        }
        return false;
    }

    private boolean isActive(TestEnvironment env, Class<?> extType) {
        if (env == null || env.testCase == null) {
            return false;
        }
        for (Class<?> outer = extType; outer != null; outer = outer.getEnclosingClass()) {
            if (!outer.isInstance((Object)env.testCase)) continue;
            return true;
        }
        return false;
    }
}

