/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test.rhino;

import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.debug.DebugFrame;
import net.sourceforge.htmlunit.corejs.javascript.debug.DebuggableScript;
import org.jvnet.hudson.test.rhino.JavaScriptDebugger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallStackFrame
implements DebugFrame {
    public final JavaScriptDebugger owner;
    public final DebuggableScript fnOrScript;
    private Scriptable activation;
    private Scriptable thisObj;
    private Object[] args;
    private int line;

    public CallStackFrame(JavaScriptDebugger owner, DebuggableScript fnOrScript) {
        this.owner = owner;
        this.fnOrScript = fnOrScript;
    }

    public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
        this.activation = activation;
        this.thisObj = thisObj;
        this.args = args;
        this.owner.callStack.add(this);
    }

    public void onExit(Context cx, boolean byThrow, Object resultOrException) {
        for (int i = this.owner.callStack.size() - 1; i >= 0; --i) {
            if (this.owner.callStack.get(i) != this) continue;
            this.owner.callStack.remove(i);
            break;
        }
        this.activation = null;
        this.thisObj = null;
        this.args = null;
        this.line = -1;
    }

    public void onLineChange(Context cx, int lineNumber) {
        this.line = lineNumber;
    }

    public void onExceptionThrown(Context cx, Throwable ex) {
    }

    public void onDebuggerStatement(Context cx) {
    }

    public SortedMap<String, Object> getVariables() {
        TreeMap<String, Object> r = new TreeMap<String, Object>();
        for (int i = this.fnOrScript.getParamAndVarCount() - 1; i >= 0; --i) {
            String name = this.fnOrScript.getParamOrVarName(i);
            r.put(name, this.activation.get(name, this.activation));
        }
        return r;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.fnOrScript.getFunctionName());
        buf.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this.args[i]);
        }
        buf.append(')');
        buf.append("\n  at ").append(this.fnOrScript.getSourceName()).append('#').append(this.line);
        buf.append("\n  variables=").append(this.getVariables());
        return buf.toString();
    }
}

