/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.AllView;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemGroupMixIn;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.model.ViewGroupMixIn;
import hudson.security.AccessControlled;
import hudson.util.Function1;
import hudson.views.DefaultViewsTabBar;
import hudson.views.ViewsTabBar;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockFolder
extends AbstractItem
implements ModifiableTopLevelItemGroup,
TopLevelItem,
ViewGroup,
StaplerFallback {
    private transient Map<String, TopLevelItem> items = new TreeMap<String, TopLevelItem>();
    private final List<View> views = new ArrayList<AllView>(Collections.singleton(new AllView("All", (ViewGroup)this)));
    private String primaryView;
    private ViewsTabBar viewsTabBar;

    private MockFolder(ItemGroup parent, String name) {
        super(parent, name);
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        this.items = ItemGroupMixIn.loadChildren((ItemGroup)this, (File)this.jobs(), (Function1)new Function1<String, TopLevelItem>(){

            public String call(TopLevelItem item) {
                return item.getName();
            }
        });
    }

    public Collection<TopLevelItem> getItems() {
        return this.items.values();
    }

    public TopLevelItem getItem(String name) {
        return this.items.get(name);
    }

    public Collection<? extends Job> getAllJobs() {
        HashSet jobs = new HashSet();
        for (TopLevelItem i : this.getItems()) {
            jobs.addAll(i.getAllJobs());
        }
        return jobs;
    }

    private File jobs() {
        return new File(this.getRootDir(), "jobs");
    }

    private ItemGroupMixIn mixin() {
        return new ItemGroupMixIn((ItemGroup)this, (AccessControlled)this){

            protected void add(TopLevelItem item) {
                MockFolder.this.items.put(item.getName(), item);
            }

            protected File getRootDirFor(String name) {
                return new File(MockFolder.this.jobs(), name);
            }
        };
    }

    private ViewGroupMixIn vgmixin() {
        return new ViewGroupMixIn(this){

            protected List<View> views() {
                return MockFolder.this.views;
            }

            protected String primaryView() {
                return MockFolder.this.primaryView != null ? MockFolder.this.primaryView : ((View)MockFolder.this.views.get(0)).getViewName();
            }

            protected void primaryView(String newName) {
                MockFolder.this.primaryView = newName;
            }
        };
    }

    public <T extends TopLevelItem> T copy(T src, String name) throws IOException {
        return (T)this.mixin().copy(src, name);
    }

    public void onCopiedFrom(Item src) {
        super.onCopiedFrom(src);
        for (TopLevelItem item : ((MockFolder)src).getItems()) {
            try {
                this.copy(item, item.getName());
            }
            catch (IOException x) {
                assert (false) : x;
            }
        }
    }

    public TopLevelItem createProjectFromXML(String name, InputStream xml) throws IOException {
        return this.mixin().createProjectFromXML(name, xml);
    }

    public TopLevelItem createProject(TopLevelItemDescriptor type, String name, boolean notify) throws IOException {
        return this.mixin().createProject(type, name, notify);
    }

    public <T extends TopLevelItem> T createProject(Class<T> type, String name) throws IOException {
        return (T)((TopLevelItem)type.cast(this.createProject((TopLevelItemDescriptor)Jenkins.getInstance().getDescriptor(type), name, true)));
    }

    public TopLevelItem doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        return this.mixin().createTopLevelItem(req, rsp);
    }

    public String getUrlChildPrefix() {
        return "job";
    }

    public File getRootDirFor(TopLevelItem child) {
        return new File(this.jobs(), child.getName());
    }

    public void onRenamed(TopLevelItem item, String oldName, String newName) throws IOException {
        this.items.remove(oldName);
        this.items.put(newName, item);
    }

    public void onDeleted(TopLevelItem item) throws IOException {
        this.items.remove(item.getName());
    }

    public TopLevelItemDescriptor getDescriptor() {
        return (TopLevelItemDescriptor)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public void addView(View view) throws IOException {
        this.vgmixin().addView(view);
    }

    public boolean canDelete(View view) {
        return this.vgmixin().canDelete(view);
    }

    public void deleteView(View view) throws IOException {
        this.vgmixin().deleteView(view);
    }

    public Collection<View> getViews() {
        return this.vgmixin().getViews();
    }

    public View getView(String name) {
        return this.vgmixin().getView(name);
    }

    public View getPrimaryView() {
        return this.vgmixin().getPrimaryView();
    }

    public void onViewRenamed(View view, String oldName, String newName) {
        this.vgmixin().onViewRenamed(view, oldName, newName);
    }

    public ViewsTabBar getViewsTabBar() {
        if (this.viewsTabBar == null) {
            this.viewsTabBar = new DefaultViewsTabBar();
        }
        return this.viewsTabBar;
    }

    public ItemGroup<? extends TopLevelItem> getItemGroup() {
        return this;
    }

    public List<Action> getViewActions() {
        return Collections.emptyList();
    }

    public Object getStaplerFallback() {
        return this.getPrimaryView();
    }

    public TopLevelItem getJob(String name) {
        return this.getItem(name);
    }

    @Extension
    public static class DescriptorImpl
    extends TopLevelItemDescriptor {
        public String getDisplayName() {
            return "MockFolder";
        }

        public TopLevelItem newInstance(ItemGroup parent, String name) {
            return new MockFolder(parent, name);
        }
    }
}

