/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.FilePath;
import hudson.remoting.Which;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;

final class WarExploder {
    private static File EXPLODE_DIR;
    private static Exception FAILURE;

    WarExploder() {
    }

    public static File getExplodedDir() throws Exception {
        if (FAILURE != null) {
            throw new Exception("Failed to initialize exploded war", FAILURE);
        }
        return EXPLODE_DIR;
    }

    private static File explode() throws Exception {
        for (File d = new File(".").getAbsoluteFile(); d != null; d = d.getParentFile()) {
            File dir;
            if (!new File(d, ".jenkins").exists() || !(dir = new File(d, "war/target/jenkins")).exists()) continue;
            System.out.println("Using jenkins.war resources from " + dir);
            return dir;
        }
        URL winstone = WarExploder.class.getResource("/winstone.jar");
        if (winstone == null) {
            throw new AssertionError((Object)"jenkins.war is not in the classpath. If you are running this from the core workspace, run 'mvn install' to create the war image in war/target/jenkins");
        }
        File war = Which.jarFile(Class.forName("executable.Executable"));
        File explodeDir = new File("./target/jenkins-for-test").getAbsoluteFile();
        File timestamp = new File(explodeDir, ".timestamp");
        if (!timestamp.exists() || timestamp.lastModified() != war.lastModified()) {
            System.out.println("Exploding jenkins.war at " + war);
            new FilePath(explodeDir).deleteRecursive();
            new FilePath(war).unzip(new FilePath(explodeDir));
            if (!explodeDir.exists()) {
                throw new IOException("Failed to explode " + war);
            }
            new FileOutputStream(timestamp).close();
            timestamp.setLastModified(war.lastModified());
        } else {
            System.out.println("Picking up existing exploded jenkins.war at " + explodeDir.getAbsolutePath());
        }
        return explodeDir;
    }

    static {
        try {
            EXPLODE_DIR = WarExploder.explode();
        }
        catch (Exception e) {
            FAILURE = e;
        }
    }
}

