/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test.recipes;

import hudson.PluginManager;
import java.io.File;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import org.jvnet.hudson.test.HudsonTestCase;
import org.jvnet.hudson.test.JenkinsRecipe;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.recipes.Recipe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Documented
@Recipe(value=RunnerImpl.class)
@JenkinsRecipe(value=RuleRunnerImpl.class)
@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface WithPluginManager {
    public Class<? extends PluginManager> value();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RuleRunnerImpl
    extends JenkinsRecipe.Runner<WithPluginManager> {
        private WithPluginManager recipe;

        @Override
        public void setup(JenkinsRule jenkinsRule, WithPluginManager recipe) throws Exception {
            this.recipe = recipe;
        }

        @Override
        public void decorateHome(JenkinsRule jenkinsRule, File home) throws Exception {
            Class<? extends PluginManager> c = this.recipe.value();
            Constructor<? extends PluginManager> ctr = c.getDeclaredConstructor(File.class);
            jenkinsRule.setPluginManager(ctr.newInstance(home));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunnerImpl
    extends Recipe.Runner<WithPluginManager> {
        private WithPluginManager recipe;

        @Override
        public void setup(HudsonTestCase testCase, WithPluginManager recipe) throws Exception {
            this.recipe = recipe;
        }

        @Override
        public void decorateHome(HudsonTestCase testCase, File home) throws Exception {
            Class<? extends PluginManager> c = this.recipe.value();
            Constructor<?> ctr = c.getConstructors()[0];
            Class<?>[] pt = ctr.getParameterTypes();
            Object[] args = new Object[pt.length];
            for (int i = 0; i < args.length; ++i) {
                Class<?> t = pt[i];
                if (t == File.class) {
                    args[i] = home;
                    continue;
                }
                if (!t.isAssignableFrom(((Object)((Object)testCase)).getClass())) continue;
                args[i] = testCase;
            }
            testCase.setPluginManager((PluginManager)ctr.newInstance(args));
        }
    }
}

