/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptErrorListener;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.Assert;

public class WebClientUtil {
    public static void waitForJSExec(WebClient webClient) {
        WebClientUtil.waitForJSExec(webClient, 10000L);
    }

    public static void waitForJSExec(WebClient webClient, long timeout) {
        webClient.getJavaScriptEngine().processPostponedActions();
        webClient.waitForBackgroundJavaScript(timeout);
    }

    public static ExceptionListener addExceptionListener(WebClient webClient) {
        ExceptionListener exceptionListener = new ExceptionListener(webClient);
        webClient.setJavaScriptErrorListener((JavaScriptErrorListener)exceptionListener);
        return exceptionListener;
    }

    public static class ExceptionListener
    implements JavaScriptErrorListener {
        private final WebClient webClient;
        private ScriptException scriptException;

        private ExceptionListener(WebClient webClient) {
            this.webClient = webClient;
        }

        public ScriptException getScriptException() {
            return this.scriptException;
        }

        public ScriptException getExpectedScriptException() {
            this.assertHasException();
            return this.scriptException;
        }

        public void scriptException(HtmlPage htmlPage, ScriptException scriptException) {
            this.scriptException = scriptException;
        }

        public void assertHasException() {
            WebClientUtil.waitForJSExec(this.webClient);
            Assert.assertNotNull((String)"A JavaScript Exception was expected.", (Object)this.scriptException);
        }

        public void timeoutError(HtmlPage htmlPage, long allowedTime, long executionTime) {
        }

        public void malformedScriptURL(HtmlPage htmlPage, String url, MalformedURLException malformedURLException) {
        }

        public void loadScriptError(HtmlPage htmlPage, URL scriptUrl, Exception exception) {
        }

        public void warn(String message, String sourceName, int line, String lineSource, int lineOffset) {
        }
    }
}

