/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.cli.CLICommand;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import jenkins.model.Jenkins;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.lang3.StringUtils;
import org.jvnet.hudson.test.JellyTestSuiteBuilder;
import org.jvnet.hudson.test.PropertiesTestSuite;

public class PluginAutomaticTestBuilder {
    public static TestSuite build(Map<String, ?> params) throws Exception {
        TestSuite master = new TestSuite();
        if (params.containsKey("outputDirectory")) {
            File outputDirectory = new File((String)params.get("outputDirectory"));
            TestSuite inJenkins = JellyTestSuiteBuilder.build(outputDirectory, PluginAutomaticTestBuilder.toBoolean(params.get("requirePI")));
            inJenkins.addTest((Test)new OtherTests("testCliSanity", params));
            String packaging = (String)StringUtils.defaultIfBlank((CharSequence)((String)params.get("packaging")), (CharSequence)"hpi");
            if ("hpi".equals(packaging)) {
                inJenkins.addTest((Test)new OtherTests("testPluginActive", params));
            }
            master.addTest((Test)inJenkins);
            master.addTest((Test)new PropertiesTestSuite(outputDirectory));
        }
        return master;
    }

    private static boolean toBoolean(Object requirePI) {
        if (requirePI == null) {
            return false;
        }
        if (requirePI instanceof Boolean) {
            return (Boolean)requirePI;
        }
        return Boolean.parseBoolean(requirePI.toString());
    }

    public static class OtherTests
    extends TestCase {
        private final Map<String, ?> params;

        public OtherTests(String name, Map<String, ?> params) {
            super(name);
            this.params = params;
        }

        public void testCliSanity() {
            CLICommand.clone((String)"help");
        }

        public void testPluginActive() {
            String plugin = (String)this.params.get("artifactId");
            if (plugin != null) {
                Iterator iterator = Jenkins.getInstance().getPluginManager().getFailedPlugins().iterator();
                if (iterator.hasNext()) {
                    PluginManager.FailedPlugin fp = (PluginManager.FailedPlugin)iterator.next();
                    throw new Error("Plugin " + fp.name + " failed to start", fp.cause);
                }
                PluginWrapper pw = Jenkins.getInstance().getPluginManager().getPlugin(plugin);
                OtherTests.assertNotNull((String)(plugin + " failed to start"), (Object)pw);
                OtherTests.assertTrue((String)(plugin + " was not active"), (boolean)pw.isActive());
            }
        }
    }
}

