/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.jvnet.hudson.test.WarExploder;

public class TestPluginManager
extends PluginManager {
    public static final PluginManager INSTANCE;
    private static final Logger LOGGER;

    public TestPluginManager() throws IOException {
        super(null, Util.createTempDir());
    }

    protected Collection<String> loadBundledPlugins() throws Exception {
        try {
            Set<String> set = this.loadBundledPlugins(new File(WarExploder.getExplodedDir(), "WEB-INF/plugins"));
            return set;
        }
        finally {
            try {
                Method loadDetachedPlugins = PluginManager.class.getDeclaredMethod("loadDetachedPlugins", new Class[0]);
                loadDetachedPlugins.setAccessible(true);
                loadDetachedPlugins.invoke((Object)this, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> loadBundledPlugins(File fromDir) throws IOException, URISyntaxException {
        URL index;
        HashSet<String> names = new HashSet<String>();
        File[] children = fromDir.listFiles();
        if (children != null) {
            for (File child : children) {
                try {
                    names.add(child.getName());
                    this.copyBundledPlugin(child.toURI().toURL(), child.getName());
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Failed to extract the bundled plugin " + child, e);
                }
            }
        } else {
            LOGGER.log(Level.FINE, "No plugins loaded from {0}. Directory does not exist.", fromDir);
        }
        URL u = ((Object)((Object)this)).getClass().getClassLoader().getResource("the.jpl");
        if (u == null) {
            u = ((Object)((Object)this)).getClass().getClassLoader().getResource("the.hpl");
        }
        if (u != null) {
            try {
                names.add("the.jpl");
                this.copyBundledPlugin(u, "the.jpl");
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to copy the.jpl", e);
            }
        }
        if ((index = ((Object)((Object)this)).getClass().getResource("/test-dependencies/index")) != null) {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(index.openStream(), "UTF-8"));){
                String line;
                while ((line = r.readLine()) != null) {
                    File f;
                    URL url = new URL(index, line + ".jpi");
                    try {
                        f = new File(url.toURI());
                    }
                    catch (IllegalArgumentException x) {
                        throw new IOException(index + " contains bogus line " + line, x);
                    }
                    if (f.exists()) {
                        this.copyBundledPlugin(url, line + ".jpi");
                        continue;
                    }
                    this.copyBundledPlugin(new URL(index, line + ".hpi"), line + ".jpi");
                }
            }
        }
        return names;
    }

    public void installDetachedPlugin(String shortName) throws Exception {
        URL r = TestPluginManager.class.getClassLoader().getResource("WEB-INF/detached-plugins/" + shortName + ".hpi");
        Assert.assertNotNull((String)("could not find " + shortName), (Object)r);
        File f = new File(this.rootDir, shortName + ".hpi");
        FileUtils.copyURLToFile((URL)r, (File)f);
        this.dynamicLoad(f);
    }

    public void stop() {
        for (PluginWrapper p : this.activePlugins) {
            p.stop();
        }
    }

    private void reallyStop() {
        super.stop();
    }

    static {
        LOGGER = Logger.getLogger(TestPluginManager.class.getName());
        try {
            INSTANCE = new TestPluginManager();
            Runtime.getRuntime().addShutdownHook(new Thread("delete " + TestPluginManager.INSTANCE.rootDir){

                @Override
                public void run() {
                    ((TestPluginManager)INSTANCE).reallyStop();
                    System.gc();
                    try {
                        Util.deleteRecursive((File)TestPluginManager.INSTANCE.rootDir);
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                    }
                }
            });
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

