/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.DefaultCssErrorHandler;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.WebClientUtil;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeUtil;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFormUtil;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLHttpRequest;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import com.google.inject.Injector;
import hudson.ClassicPluginStrategy;
import hudson.CloseProofOutputStream;
import hudson.DNSMultiCast;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.Launcher;
import hudson.PluginManager;
import hudson.Util;
import hudson.WebAppMain;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DownloadService;
import hudson.model.Executor;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.RootAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.UpdateSite;
import hudson.model.View;
import hudson.os.PosixAPI;
import hudson.security.ACL;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.csrf.CrumbIssuer;
import hudson.slaves.ComputerConnector;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerListener;
import hudson.slaves.DumbSlave;
import hudson.slaves.RetentionStrategy;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.tools.ToolProperty;
import hudson.util.PersistedList;
import hudson.util.ReflectionUtils;
import hudson.util.StreamTaskListener;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsAdaptor;
import jenkins.model.JenkinsLocationConfiguration;
import junit.framework.TestCase;
import net.sf.json.JSONObject;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextFactory;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.debug.Debugger;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.jvnet.hudson.test.ClosureExecuterAction;
import org.jvnet.hudson.test.ComputerConnectorTester;
import org.jvnet.hudson.test.EndOfTestListener;
import org.jvnet.hudson.test.FakeLauncher;
import org.jvnet.hudson.test.HudsonHomeLoader;
import org.jvnet.hudson.test.HudsonPageCreator;
import org.jvnet.hudson.test.JavaNetReverseProxy;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LenientRunnable;
import org.jvnet.hudson.test.NoListenerConfiguration;
import org.jvnet.hudson.test.PretendSlave;
import org.jvnet.hudson.test.SimpleCommandLauncher;
import org.jvnet.hudson.test.TestCrumbIssuer;
import org.jvnet.hudson.test.TestEnvironment;
import org.jvnet.hudson.test.TestPluginManager;
import org.jvnet.hudson.test.ThreadPoolImpl;
import org.jvnet.hudson.test.WarExploder;
import org.jvnet.hudson.test.WithoutJenkins;
import org.jvnet.hudson.test.recipes.Recipe;
import org.jvnet.hudson.test.rhino.JavaScriptDebugger;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.shell.Global;
import org.springframework.dao.DataAccessException;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Deprecated
public abstract class HudsonTestCase
extends TestCase
implements RootAction {
    public Hudson hudson;
    public Jenkins jenkins;
    protected final TestEnvironment env = new TestEnvironment(this);
    protected HudsonHomeLoader homeLoader = HudsonHomeLoader.NEW;
    protected int localPort;
    protected Server server;
    protected String contextPath = "";
    protected List<LenientRunnable> tearDowns = new ArrayList<LenientRunnable>();
    protected List<Recipe.Runner> recipes = new ArrayList<Recipe.Runner>();
    private List<WebClient> clients = new ArrayList<WebClient>();
    protected JavaScriptDebugger jsDebugger = new JavaScriptDebugger();
    public boolean useLocalPluginManager;
    public int timeout = Integer.getInteger("jenkins.test.timeout", 180);
    private volatile Timer timeoutTimer;
    private PluginManager pluginManager = TestPluginManager.INSTANCE;
    public ComputerConnectorTester computerConnectorTester = new ComputerConnectorTester(this);
    protected File explodedWarDir;
    private boolean origDefaultUseCache = true;
    private static final Logger XML_HTTP_REQUEST_LOGGER = Logger.getLogger(XMLHttpRequest.class.getName());
    private static final Logger LOGGER;
    protected static final List<ToolProperty<?>> NO_PROPERTIES;
    public static int SLAVE_DEBUG_PORT;
    public static final MimeTypes MIME_TYPES;

    protected HudsonTestCase(String name) {
        super(name);
    }

    protected HudsonTestCase() {
    }

    public void runBare() throws Throwable {
        Thread t = Thread.currentThread();
        String o = ((Object)((Object)this)).getClass().getName() + '.' + t.getName();
        t.setName("Executing " + this.getName());
        try {
            super.runBare();
        }
        finally {
            t.setName(o);
        }
    }

    protected void setUp() throws Exception {
        if (Thread.interrupted()) {
            LOGGER.warning("was interrupted before start");
        }
        if (Functions.isWindows()) {
            URLConnection aConnection = new File(".").toURI().toURL().openConnection();
            this.origDefaultUseCache = aConnection.getDefaultUseCaches();
            aConnection.setDefaultUseCaches(false);
        }
        this.env.pin();
        this.recipe();
        for (Recipe.Runner r : this.recipes) {
            if (!(r instanceof WithoutJenkins.RunnerImpl)) continue;
            return;
        }
        AbstractProject.WORKSPACE.toString();
        hudson.model.User.clear();
        ExtensionList.clearLegacyInstances();
        DescriptorExtensionList.clearLegacyInstances();
        try {
            this.hudson = this.newHudson();
            this.jenkins = this.hudson;
        }
        catch (Exception e) {
            Field f = Jenkins.class.getDeclaredField("theInstance");
            f.setAccessible(true);
            f.set(null, null);
            throw e;
        }
        this.jenkins.setNoUsageStatistics(Boolean.valueOf(true));
        this.jenkins.setCrumbIssuer((CrumbIssuer)new TestCrumbIssuer());
        this.jenkins.servletContext.setAttribute("app", (Object)this.jenkins);
        this.jenkins.servletContext.setAttribute("version", (Object)"?");
        WebAppMain.installExpressionFactory((ServletContextEvent)new ServletContextEvent(this.jenkins.servletContext));
        JenkinsLocationConfiguration.get().setUrl(this.getURL().toString());
        this.jenkins.getJDKs().add(new JDK("default", System.getProperty("java.home")));
        this.configureUpdateCenter();
        this.jenkins.getActions().add(this);
        for (Descriptor d : this.jenkins.getExtensionList(Descriptor.class)) {
            d.load();
        }
        ((Injector)Jenkins.lookup(Injector.class)).injectMembers((Object)this);
        this.setUpTimeout();
    }

    protected void setUpTimeout() {
        if (this.timeout <= 0) {
            return;
        }
        final Thread testThread = Thread.currentThread();
        this.timeoutTimer = new Timer();
        this.timeoutTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (HudsonTestCase.this.timeoutTimer != null) {
                    LOGGER.warning(String.format("Test timed out (after %d seconds).", HudsonTestCase.this.timeout));
                    testThread.interrupt();
                }
            }
        }, TimeUnit.SECONDS.toMillis(this.timeout));
    }

    protected void configureUpdateCenter() throws Exception {
        String updateCenterUrl = "http://localhost:" + JavaNetReverseProxy.getInstance().localPort + "/update-center.json";
        DownloadService.neverUpdate = true;
        UpdateSite.neverUpdate = true;
        PersistedList sites = this.jenkins.getUpdateCenter().getSites();
        sites.clear();
        sites.add((Object)new UpdateSite("default", updateCenterUrl));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tearDown() throws Exception {
        block15: {
            try {
                if (this.jenkins != null) {
                    for (EndOfTestListener tl : this.jenkins.getExtensionList(EndOfTestListener.class)) {
                        tl.onTearDown();
                    }
                }
                if (this.timeoutTimer != null) {
                    this.timeoutTimer.cancel();
                    this.timeoutTimer = null;
                }
                for (WebClient client : this.clients) {
                    client.getPage("about:blank");
                    client.close();
                }
                this.clients.clear();
                if (this.server == null) break block15;
            }
            catch (Throwable throwable) {
                if (this.server != null) {
                    this.server.stop();
                }
                for (LenientRunnable r : this.tearDowns) {
                    r.run();
                }
                if (this.jenkins != null) {
                    this.jenkins.cleanUp();
                }
                ExtensionList.clearLegacyInstances();
                DescriptorExtensionList.clearLegacyInstances();
                try {
                    this.env.dispose();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                System.gc();
                if (!Functions.isWindows()) throw throwable;
                URLConnection aConnection2 = new File(".").toURI().toURL().openConnection();
                aConnection2.setDefaultUseCaches(this.origDefaultUseCache);
                throw throwable;
            }
            this.server.stop();
        }
        for (LenientRunnable r : this.tearDowns) {
            r.run();
        }
        if (this.jenkins != null) {
            this.jenkins.cleanUp();
        }
        ExtensionList.clearLegacyInstances();
        DescriptorExtensionList.clearLegacyInstances();
        try {
            this.env.dispose();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        System.gc();
        if (!Functions.isWindows()) return;
        URLConnection aConnection = new File(".").toURI().toURL().openConnection();
        aConnection.setDefaultUseCaches(this.origDefaultUseCache);
    }

    protected void runTest() throws Throwable {
        System.out.println("=== Starting " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.getName());
        ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            super.runTest();
        }
        catch (Throwable t) {
            try {
                throw new BreakException();
            }
            catch (BreakException breakException) {
                ThreadInfo[] threadInfos = Functions.getThreadInfos();
                Functions.ThreadGroupMap m = Functions.sortThreadsAndGetGroupMap((ThreadInfo[])threadInfos);
                for (ThreadInfo ti : threadInfos) {
                    System.err.println(Functions.dumpThreadInfo((ThreadInfo)ti, (Functions.ThreadGroupMap)m));
                }
                throw t;
            }
        }
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "self";
    }

    protected Hudson newHudson() throws Exception {
        File home = this.homeLoader.allocate();
        for (Recipe.Runner r : this.recipes) {
            r.decorateHome(this, home);
        }
        return new Hudson(home, this.createWebServer(), this.useLocalPluginManager ? null : this.pluginManager);
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.useLocalPluginManager = false;
        this.pluginManager = pluginManager;
        if (this.jenkins != null) {
            throw new IllegalStateException("Too late to override the plugin manager");
        }
    }

    protected ServletContext createWebServer() throws Exception {
        this.server = new Server((ThreadPool)new ThreadPoolImpl(new ThreadPoolExecutor(10, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Jetty Thread Pool");
                return t;
            }
        })));
        this.explodedWarDir = WarExploder.getExplodedDir();
        WebAppContext context = new WebAppContext(this.explodedWarDir.getPath(), this.contextPath);
        context.setResourceBase(this.explodedWarDir.getPath());
        context.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        context.setConfigurations(new Configuration[]{new WebXmlConfiguration()});
        context.addBean((Object)new NoListenerConfiguration(context));
        this.server.setHandler((Handler)context);
        context.setMimeTypes(MIME_TYPES);
        context.getSecurityHandler().setLoginService(this.configureUserRealm());
        ServerConnector connector = new ServerConnector(this.server);
        HttpConfiguration config = ((HttpConnectionFactory)connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration();
        config.setRequestHeaderSize(12288);
        connector.setHost("localhost");
        this.server.addConnector((Connector)connector);
        this.server.start();
        this.localPort = connector.getLocalPort();
        return context.getServletContext();
    }

    protected LoginService configureUserRealm() {
        HashLoginService realm = new HashLoginService();
        realm.setName("default");
        UserStore userStore = new UserStore();
        realm.setUserStore(userStore);
        userStore.addUser("alice", (Credential)new Password("alice"), new String[]{"user", "female"});
        userStore.addUser("bob", (Credential)new Password("bob"), new String[]{"user", "male"});
        userStore.addUser("charlie", (Credential)new Password("charlie"), new String[]{"user", "male"});
        return realm;
    }

    protected FreeStyleProject createFreeStyleProject() throws IOException {
        return this.createFreeStyleProject(this.createUniqueProjectName());
    }

    protected FreeStyleProject createFreeStyleProject(String name) throws IOException {
        return (FreeStyleProject)this.jenkins.createProject(FreeStyleProject.class, name);
    }

    protected String createUniqueProjectName() {
        return "test" + this.jenkins.getItems().size();
    }

    protected Launcher.LocalLauncher createLocalLauncher() {
        return new Launcher.LocalLauncher((TaskListener)StreamTaskListener.fromStdout());
    }

    public File createTmpDir() throws IOException {
        return this.env.temporaryDirectoryAllocator.allocate();
    }

    public DumbSlave createSlave() throws Exception {
        return this.createSlave("", null);
    }

    public DumbSlave createSlave(Label l) throws Exception {
        return this.createSlave(l, null);
    }

    public SecurityRealm createDummySecurityRealm() {
        return new AbstractPasswordBasedSecurityRealm(){

            protected UserDetails authenticate(String username, String password) throws AuthenticationException {
                if (username.equals(password)) {
                    return this.loadUserByUsername(username);
                }
                throw new BadCredentialsException(username);
            }

            public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
                return new User(username, "", true, true, true, true, new GrantedAuthority[]{AUTHENTICATED_AUTHORITY});
            }

            public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
                throw new UsernameNotFoundException(groupname);
            }
        };
    }

    public URL getURL() throws IOException {
        return new URL("http://localhost:" + this.localPort + this.contextPath + "/");
    }

    public DumbSlave createSlave(EnvVars env) throws Exception {
        return this.createSlave("", env);
    }

    public DumbSlave createSlave(Label l, EnvVars env) throws Exception {
        return this.createSlave(l == null ? null : l.getExpression(), env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DumbSlave createSlave(String labels, EnvVars env) throws Exception {
        Jenkins jenkins = this.jenkins;
        synchronized (jenkins) {
            int sz = this.jenkins.getNodes().size();
            return this.createSlave("slave" + sz, labels, env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DumbSlave createSlave(String nodeName, String labels, EnvVars env) throws Exception {
        Jenkins jenkins = this.jenkins;
        synchronized (jenkins) {
            DumbSlave slave = new DumbSlave(nodeName, "dummy", this.createTmpDir().getPath(), "1", Node.Mode.NORMAL, labels == null ? "" : labels, this.createComputerLauncher(env), RetentionStrategy.NOOP, Collections.emptyList());
            this.jenkins.addNode((hudson.model.Node)slave);
            return slave;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PretendSlave createPretendSlave(FakeLauncher faker) throws Exception {
        Jenkins jenkins = this.jenkins;
        synchronized (jenkins) {
            int sz = this.jenkins.getNodes().size();
            PretendSlave slave = new PretendSlave("slave" + sz, this.createTmpDir().getPath(), "", this.createComputerLauncher(null), faker);
            this.jenkins.addNode((hudson.model.Node)slave);
            return slave;
        }
    }

    public ComputerLauncher createComputerLauncher(EnvVars env) throws URISyntaxException, IOException {
        int sz = this.jenkins.getNodes().size();
        return new SimpleCommandLauncher(String.format("\"%s/bin/java\" %s %s -jar \"%s\"", System.getProperty("java.home"), SLAVE_DEBUG_PORT > 0 ? " -Xdebug -Xrunjdwp:transport=dt_socket,server=y,address=" + (SLAVE_DEBUG_PORT + sz) : "", "-Djava.awt.headless=true", new File(this.jenkins.getJnlpJars("slave.jar").getURL().toURI()).getAbsolutePath()), env);
    }

    public DumbSlave createOnlineSlave() throws Exception {
        return this.createOnlineSlave(null);
    }

    public DumbSlave createOnlineSlave(Label l) throws Exception {
        return this.createOnlineSlave(l, null);
    }

    public DumbSlave createOnlineSlave(Label l, EnvVars env) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ComputerListener waiter = new ComputerListener(){

            public void onOnline(Computer C, TaskListener t) {
                latch.countDown();
                this.unregister();
            }
        };
        waiter.register();
        DumbSlave s = this.createSlave(l, env);
        latch.await();
        return s;
    }

    public void interactiveBreak() throws Exception {
        System.out.println("Jenkins is running at http://localhost:" + this.localPort + "/");
        new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    protected <T> T last(List<T> items) {
        return items.get(items.size() - 1);
    }

    protected void pause() throws IOException {
        new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    protected Page search(String q) throws Exception {
        return new WebClient().search(q);
    }

    protected void configRoundtrip() throws Exception {
        this.submit(this.createWebClient().goTo("configure").getFormByName("config"));
    }

    protected <P extends Job> P configRoundtrip(P job) throws Exception {
        this.submit(this.createWebClient().getPage((Item)job, "configure").getFormByName("config"));
        return job;
    }

    protected <P extends Item> P configRoundtrip(P job) throws Exception {
        this.submit(this.createWebClient().getPage(job, "configure").getFormByName("config"));
        return job;
    }

    protected <B extends Builder> B configRoundtrip(B before) throws Exception {
        FreeStyleProject p = this.createFreeStyleProject();
        p.getBuildersList().add(before);
        this.configRoundtrip(p);
        return (B)((Builder)p.getBuildersList().get(before.getClass()));
    }

    protected <P extends Publisher> P configRoundtrip(P before) throws Exception {
        FreeStyleProject p = this.createFreeStyleProject();
        p.getPublishersList().add(before);
        this.configRoundtrip(p);
        return (P)((Publisher)p.getPublishersList().get(before.getClass()));
    }

    protected <C extends ComputerConnector> C configRoundtrip(C before) throws Exception {
        this.computerConnectorTester.connector = before;
        this.submit(this.createWebClient().goTo("self/computerConnectorTester/configure").getFormByName("config"));
        return (C)this.computerConnectorTester.connector;
    }

    protected hudson.model.User configRoundtrip(hudson.model.User u) throws Exception {
        this.submit(this.createWebClient().goTo(u.getUrl() + "/configure").getFormByName("config"));
        return u;
    }

    protected <N extends hudson.model.Node> N configRoundtrip(N node) throws Exception {
        this.submit(this.createWebClient().goTo("/computer/" + node.getNodeName() + "/configure").getFormByName("config"));
        return (N)this.jenkins.getNode(node.getNodeName());
    }

    protected <V extends View> V configRoundtrip(V view) throws Exception {
        this.submit(this.createWebClient().getPage(view, "configure").getFormByName("viewConfig"));
        return view;
    }

    public <R extends Run> R assertBuildStatus(Result status, R r) throws Exception {
        if (status == r.getResult()) {
            return r;
        }
        String msg = "unexpected build status; build log was:\n------\n" + HudsonTestCase.getLog(r) + "\n------\n";
        HudsonTestCase.assertEquals((String)msg, (Object)status, (Object)r.getResult());
        return r;
    }

    public boolean isGoodHttpStatus(int status) {
        if (400 <= status && status <= 417) {
            return false;
        }
        return 500 > status || status > 505;
    }

    public void assertGoodStatus(Page page) {
        HudsonTestCase.assertTrue((boolean)this.isGoodHttpStatus(page.getWebResponse().getStatusCode()));
    }

    public <R extends Run> R assertBuildStatusSuccess(R r) throws Exception {
        this.assertBuildStatus(Result.SUCCESS, r);
        return r;
    }

    public <R extends Run> R assertBuildStatusSuccess(Future<? extends R> r) throws Exception {
        HudsonTestCase.assertNotNull((String)"build was actually scheduled", r);
        return (R)this.assertBuildStatusSuccess((Run)r.get());
    }

    public <J extends AbstractProject<J, R>, R extends AbstractBuild<J, R>> R buildAndAssertSuccess(J job) throws Exception {
        return (R)((AbstractBuild)this.assertBuildStatusSuccess((Future<? extends R>)job.scheduleBuild2(0)));
    }

    public FreeStyleBuild buildAndAssertSuccess(FreeStyleProject job) throws Exception {
        return (FreeStyleBuild)this.assertBuildStatusSuccess((Future)job.scheduleBuild2(0));
    }

    public void assertLogContains(String substring, Run run) throws Exception {
        String log = HudsonTestCase.getLog(run);
        HudsonTestCase.assertTrue((String)("Console output of " + run + " didn't contain " + substring + ":\n" + log), (boolean)log.contains(substring));
    }

    public void assertLogNotContains(String substring, Run run) throws Exception {
        String log = HudsonTestCase.getLog(run);
        HudsonTestCase.assertFalse((String)("Console output of " + run + " contains " + substring + ":\n" + log), (boolean)log.contains(substring));
    }

    protected static String getLog(Run run) throws IOException {
        return Util.loadFile((File)run.getLogFile(), (Charset)run.getCharset());
    }

    public void assertXPath(HtmlPage page, String xpath) {
        HudsonTestCase.assertNotNull((String)("There should be an object that matches XPath:" + xpath), DomNodeUtil.selectSingleNode((DomNode)page.getDocumentElement(), xpath));
    }

    public void assertXPath(DomNode page, String xpath) {
        List nodes = page.getByXPath(xpath);
        HudsonTestCase.assertFalse((String)("There should be an object that matches XPath:" + xpath), (boolean)nodes.isEmpty());
    }

    public void assertXPathValue(DomNode page, String xpath, String expectedValue) {
        Object node = page.getFirstByXPath(xpath);
        HudsonTestCase.assertNotNull((String)"no node found", (Object)node);
        HudsonTestCase.assertTrue((String)("the found object was not a Node " + xpath), (boolean)(node instanceof Node));
        Node n = (Node)node;
        String textString = n.getTextContent();
        HudsonTestCase.assertEquals((String)("xpath value should match for " + xpath), (String)expectedValue, (String)textString);
    }

    public void assertXPathValueContains(DomNode page, String xpath, String needle) {
        Object node = page.getFirstByXPath(xpath);
        HudsonTestCase.assertNotNull((String)"no node found", (Object)node);
        HudsonTestCase.assertTrue((String)("the found object was not a Node " + xpath), (boolean)(node instanceof Node));
        Node n = (Node)node;
        String textString = n.getTextContent();
        HudsonTestCase.assertTrue((String)"needle found in haystack", (boolean)textString.contains(needle));
    }

    public void assertXPathResultsContainText(DomNode page, String xpath, String needle) {
        List nodes = page.getByXPath(xpath);
        HudsonTestCase.assertFalse((String)"no nodes matching xpath found", (boolean)nodes.isEmpty());
        boolean found = false;
        for (Object o : nodes) {
            Node n;
            String textString;
            if (!(o instanceof Node) || (textString = (n = (Node)o).getTextContent()) == null || !textString.contains(needle)) continue;
            found = true;
            break;
        }
        HudsonTestCase.assertTrue((String)"needle found in haystack", (boolean)found);
    }

    public void assertAllImageLoadSuccessfully(HtmlPage p) {
        for (HtmlImage img : DomNodeUtil.selectNodes((DomNode)p, "//IMG")) {
            try {
                img.getHeight();
            }
            catch (IOException e) {
                throw new Error("Failed to load " + img.getSrcAttribute(), e);
            }
        }
    }

    public void assertStringContains(String message, String haystack, String needle) {
        HudsonTestCase.assertTrue((String)(message + " (seeking '" + needle + "')"), (boolean)haystack.contains(needle));
    }

    public void assertStringContains(String haystack, String needle) {
        HudsonTestCase.assertTrue((String)("Could not find '" + needle + "'."), (boolean)haystack.contains(needle));
    }

    public void assertHelpExists(final Class<? extends Describable> type, final String properties) throws Exception {
        this.executeOnServer(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Descriptor d = HudsonTestCase.this.jenkins.getDescriptor(type);
                WebClient wc = HudsonTestCase.this.createWebClient();
                for (String property : HudsonTestCase.this.listProperties(properties)) {
                    String url = d.getHelpFile(property);
                    TestCase.assertNotNull((String)("Help file for the property " + property + " is missing on " + type), (Object)url);
                    wc.goTo(url);
                }
                return null;
            }
        });
    }

    private List<String> listProperties(String properties) {
        ArrayList<String> props = new ArrayList<String>(Arrays.asList(properties.split(",")));
        for (String p : props.toArray(new String[props.size()])) {
            if (!p.startsWith("-")) continue;
            props.remove(p);
            props.remove(p.substring(1));
        }
        return props;
    }

    public HtmlPage submit(HtmlForm form) throws Exception {
        return (HtmlPage)HtmlFormUtil.submit(form, (HtmlElement)this.last(form.getHtmlElementsByTagName("button")));
    }

    public HtmlPage submit(HtmlForm form, String name) throws Exception {
        for (HtmlElement e : form.getHtmlElementsByTagName("button")) {
            HtmlElement p = (HtmlElement)e.getParentNode().getParentNode();
            if (!(e instanceof HtmlButton) || !p.getAttribute("name").equals(name)) continue;
            return (HtmlPage)HtmlFormUtil.submit(form, (HtmlElement)((HtmlButton)e));
        }
        throw new AssertionError((Object)("No such submit button with the name " + name));
    }

    protected HtmlInput findPreviousInputElement(HtmlElement current, String name) {
        return (HtmlInput)DomNodeUtil.selectSingleNode((DomNode)current, "(preceding::input[@name='_." + name + "'])[last()]");
    }

    protected HtmlButton getButtonByCaption(HtmlForm f, String s) {
        for (HtmlElement b : f.getHtmlElementsByTagName("button")) {
            if (!b.getTextContent().trim().equals(s)) continue;
            return (HtmlButton)b;
        }
        return null;
    }

    public TaskListener createTaskListener() {
        return new StreamTaskListener((OutputStream)new CloseProofOutputStream((OutputStream)System.out));
    }

    public void assertEqualBeans(Object lhs, Object rhs, String properties) throws Exception {
        HudsonTestCase.assertNotNull((String)"lhs is null", (Object)lhs);
        HudsonTestCase.assertNotNull((String)"rhs is null", (Object)rhs);
        for (String p : properties.split(",")) {
            Object rp;
            Object lp;
            PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)lhs, (String)p);
            if (pd == null) {
                try {
                    Field f = lhs.getClass().getField(p);
                    lp = f.get(lhs);
                    rp = f.get(rhs);
                }
                catch (NoSuchFieldException e) {
                    HudsonTestCase.assertNotNull((String)("No such property " + p + " on " + lhs.getClass()), (Object)pd);
                    return;
                }
            } else {
                lp = PropertyUtils.getProperty((Object)lhs, (String)p);
                rp = PropertyUtils.getProperty((Object)rhs, (String)p);
            }
            if (lp != null && rp != null && lp.getClass().isArray() && rp.getClass().isArray()) {
                int m = Array.getLength(lp);
                int n = Array.getLength(rp);
                HudsonTestCase.assertEquals((String)("Array length is different for property " + p), (int)m, (int)n);
                for (int i = 0; i < m; ++i) {
                    HudsonTestCase.assertEquals((String)(p + "[" + i + "] is different"), (Object)Array.get(lp, i), (Object)Array.get(rp, i));
                }
                return;
            }
            HudsonTestCase.assertEquals((String)("Property " + p + " is different"), (Object)lp, (Object)rp);
        }
    }

    protected void setQuietPeriod(int qp) {
        JenkinsAdaptor.setQuietPeriod(this.jenkins, qp);
    }

    public void assertEqualDataBoundBeans(Object lhs, Object rhs) throws Exception {
        if (lhs == null && rhs == null) {
            return;
        }
        if (lhs == null) {
            HudsonTestCase.fail((String)("lhs is null while rhs=" + rhs));
        }
        if (rhs == null) {
            HudsonTestCase.fail((String)("rhs is null while lhs=" + lhs));
        }
        Constructor<?> lc = this.findDataBoundConstructor(lhs.getClass());
        Constructor<?> rc = this.findDataBoundConstructor(rhs.getClass());
        HudsonTestCase.assertEquals((String)"Data bound constructor mismatch. Different type?", lc, rc);
        ArrayList<String> primitiveProperties = new ArrayList<String>();
        String[] names = ClassDescriptor.loadParameterNames(lc);
        Class<?>[] types = lc.getParameterTypes();
        HudsonTestCase.assertEquals((int)names.length, (int)types.length);
        for (int i = 0; i < types.length; ++i) {
            Object lv = ReflectionUtils.getPublicProperty((Object)lhs, (String)names[i]);
            Object rv = ReflectionUtils.getPublicProperty((Object)rhs, (String)names[i]);
            if (Iterable.class.isAssignableFrom(types[i])) {
                Iterable lcol = (Iterable)lv;
                Iterable rcol = (Iterable)rv;
                Iterator ltr = lcol.iterator();
                Iterator rtr = rcol.iterator();
                while (ltr.hasNext() && rtr.hasNext()) {
                    Object litem = ltr.next();
                    Object ritem = rtr.next();
                    if (this.findDataBoundConstructor(litem.getClass()) != null) {
                        this.assertEqualDataBoundBeans(litem, ritem);
                        continue;
                    }
                    HudsonTestCase.assertEquals(litem, ritem);
                }
                HudsonTestCase.assertFalse((String)("collection size mismatch between " + lhs + " and " + rhs), (boolean)(ltr.hasNext() ^ rtr.hasNext()));
                continue;
            }
            if (this.findDataBoundConstructor(types[i]) != null || lv != null && this.findDataBoundConstructor(lv.getClass()) != null || rv != null && this.findDataBoundConstructor(rv.getClass()) != null) {
                this.assertEqualDataBoundBeans(lv, rv);
                continue;
            }
            primitiveProperties.add(names[i]);
        }
        if (!primitiveProperties.isEmpty()) {
            this.assertEqualBeans(lhs, rhs, Util.join(primitiveProperties, (String)","));
        }
    }

    public void assertEqualDataBoundBeans(List<?> lhs, List<?> rhs) throws Exception {
        HudsonTestCase.assertEquals((int)lhs.size(), (int)rhs.size());
        for (int i = 0; i < lhs.size(); ++i) {
            this.assertEqualDataBoundBeans(lhs.get(i), rhs.get(i));
        }
    }

    protected Constructor<?> findDataBoundConstructor(Class<?> c) {
        for (Constructor<?> m : c.getConstructors()) {
            if (m.getAnnotation(DataBoundConstructor.class) == null) continue;
            return m;
        }
        return null;
    }

    protected <T extends Descriptor<?>> T get(Class<T> d) {
        return (T)this.jenkins.getDescriptorByType(d);
    }

    protected boolean isSomethingHappening() {
        if (!this.jenkins.getQueue().isEmpty()) {
            return true;
        }
        for (Computer n : this.jenkins.getComputers()) {
            if (n.isIdle()) continue;
            return true;
        }
        return false;
    }

    protected void waitUntilNoActivity() throws Exception {
        this.waitUntilNoActivityUpTo(60000);
    }

    protected void waitUntilNoActivityUpTo(int timeout) throws Exception {
        long startTime = System.currentTimeMillis();
        int streak = 0;
        do {
            Thread.sleep(100L);
            streak = this.isSomethingHappening() ? 0 : ++streak;
            if (streak <= 2) continue;
            return;
        } while (System.currentTimeMillis() - startTime <= (long)timeout);
        ArrayList<Queue.Executable> building = new ArrayList<Queue.Executable>();
        for (Computer c : this.jenkins.getComputers()) {
            for (Executor e : c.getExecutors()) {
                if (!e.isBusy()) continue;
                building.add(e.getCurrentExecutable());
            }
        }
        throw new AssertionError((Object)String.format("Jenkins is still doing something after %dms: queue=%s building=%s", timeout, Arrays.asList(this.jenkins.getQueue().getItems()), building));
    }

    protected void recipe() throws Exception {
        this.recipeLoadCurrentPlugin();
        try {
            Method runMethod = ((Object)((Object)this)).getClass().getMethod(this.getName(), new Class[0]);
            for (final Annotation a : runMethod.getAnnotations()) {
                Recipe r = a.annotationType().getAnnotation(Recipe.class);
                if (r == null) continue;
                final Recipe.Runner runner = r.value().newInstance();
                this.recipes.add(runner);
                this.tearDowns.add(new LenientRunnable(){

                    @Override
                    public void run() throws Exception {
                        runner.tearDown(HudsonTestCase.this, a);
                    }
                });
                runner.setup(this, a);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected void recipeLoadCurrentPlugin() throws Exception {
        Enumeration<URL> jpls = ((Object)((Object)this)).getClass().getClassLoader().getResources("the.jpl");
        Enumeration<URL> hpls = ((Object)((Object)this)).getClass().getClassLoader().getResources("the.hpl");
        final ArrayList<URL> all = Collections.list(jpls);
        all.addAll(Collections.list(hpls));
        if (all.isEmpty()) {
            return;
        }
        this.recipes.add(new Recipe.Runner(){

            @Override
            public void decorateHome(HudsonTestCase testCase, File home) throws Exception {
                JenkinsRule.decorateHomeFor(home, all);
            }
        });
    }

    public HudsonTestCase withNewHome() {
        return this.with(HudsonHomeLoader.NEW);
    }

    public HudsonTestCase withExistingHome(File source) throws Exception {
        return this.with(new HudsonHomeLoader.CopyExisting(source));
    }

    public HudsonTestCase withPresetData(String name) {
        name = "/" + name + ".zip";
        URL res = ((Object)((Object)this)).getClass().getResource(name);
        if (res == null) {
            throw new IllegalArgumentException("No such data set found: " + name);
        }
        return this.with(new HudsonHomeLoader.CopyExisting(res));
    }

    public HudsonTestCase with(HudsonHomeLoader homeLoader) {
        this.homeLoader = homeLoader;
        return this;
    }

    public <V> V executeOnServer(Callable<V> c) throws Exception {
        return this.createWebClient().executeOnServer(c);
    }

    private Object writeReplace() {
        throw new AssertionError((Object)("HudsonTestCase " + this.getName() + " is not supposed to be serialized"));
    }

    public WebClient createWebClient() {
        return new WebClient();
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
        Dispatcher.TRACE = true;
        MetaClass.NO_CACHE = true;
        File dir = new File("src/main/resources");
        if (dir.exists() && MetaClassLoader.debugLoader == null) {
            try {
                MetaClassLoader.debugLoader = new MetaClassLoader((ClassLoader)new URLClassLoader(new URL[]{dir.toURI().toURL()}));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        Logger.getLogger("org.springframework").setLevel(Level.WARNING);
        hudson.Main.isUnitTest = true;
        XML_HTTP_REQUEST_LOGGER.setFilter(new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                return !record.getMessage().contains("XMLHttpRequest.getResponseHeader() was called before the response was available.");
            }
        });
        System.setProperty("org.mortbay.jetty.Request.maxFormContentSize", "-1");
        LOGGER = Logger.getLogger(HudsonTestCase.class.getName());
        NO_PROPERTIES = Collections.emptyList();
        SLAVE_DEBUG_PORT = Integer.getInteger(HudsonTestCase.class.getName() + ".slaveDebugPort", -1);
        MIME_TYPES = new MimeTypes();
        MIME_TYPES.addMimeMapping("js", "application/javascript");
        Functions.DEBUG_YUI = true;
        ClassicPluginStrategy.useAntClassLoader = true;
        DNSMultiCast.disabled = true;
        if (!Functions.isWindows()) {
            try {
                PosixAPI.jnr().unsetenv("MAVEN_OPTS");
                PosixAPI.jnr().unsetenv("MAVEN_DEBUG_OPTS");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to cancel out MAVEN_OPTS", e);
            }
        }
    }

    public static class TestBuildWrapper
    extends BuildWrapper {
        public Result buildResultInTearDown;

        public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
            return new BuildWrapper.Environment(){

                public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                    buildResultInTearDown = build.getResult();
                    return true;
                }
            };
        }

        @Extension
        public static class TestBuildWrapperDescriptor
        extends BuildWrapperDescriptor {
            public boolean isApplicable(AbstractProject<?, ?> project) {
                return true;
            }

            public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) {
                throw new UnsupportedOperationException();
            }

            public String getDisplayName() {
                return "TestBuildWrapper";
            }
        }
    }

    public class WebClient
    extends com.gargoylesoftware.htmlunit.WebClient {
        private static final long serialVersionUID = 8720028298174337333L;

        public WebClient() {
            super(BrowserVersion.FIREFOX_38);
            this.setPageCreator((PageCreator)HudsonPageCreator.INSTANCE);
            HudsonTestCase.this.clients.add(this);
            this.setAjaxController(new AjaxController(){
                private static final long serialVersionUID = 6730107519583349963L;

                public boolean processSynchron(HtmlPage page, WebRequest settings, boolean async) {
                    return false;
                }
            });
            this.setCssErrorHandler(new ErrorHandler(){
                final ErrorHandler defaultHandler = new DefaultCssErrorHandler();

                public void warning(CSSParseException exception) throws CSSException {
                    if (!this.ignore(exception)) {
                        this.defaultHandler.warning(exception);
                    }
                }

                public void error(CSSParseException exception) throws CSSException {
                    if (!this.ignore(exception)) {
                        this.defaultHandler.error(exception);
                    }
                }

                public void fatalError(CSSParseException exception) throws CSSException {
                    if (!this.ignore(exception)) {
                        this.defaultHandler.fatalError(exception);
                    }
                }

                private boolean ignore(CSSParseException e) {
                    return e.getURI().contains("/yui/");
                }
            });
            this.getJavaScriptEngine().getContextFactory().addListener(new ContextFactory.Listener(){

                public void contextCreated(Context cx) {
                    if (cx.getDebugger() == null) {
                        cx.setDebugger((Debugger)HudsonTestCase.this.jsDebugger, null);
                    }
                }

                public void contextReleased(Context cx) {
                }
            });
            this.setAlertHandler(new AlertHandler(){

                public void handleAlert(Page page, String message) {
                    throw new AssertionError((Object)("Alert dialog poped up: " + message));
                }
            });
        }

        public WebClient login(String username, String password) throws Exception {
            HtmlPage page = this.goTo("/login");
            HtmlForm form = page.getFormByName("login");
            form.getInputByName("j_username").setValueAttribute(username);
            form.getInputByName("j_password").setValueAttribute(password);
            HtmlFormUtil.submit(form, null);
            return this;
        }

        public WebClient login(String username) throws Exception {
            this.login(username, username);
            return this;
        }

        public <V> V executeOnServer(final Callable<V> c) throws Exception {
            final Exception[] t = new Exception[1];
            final ArrayList r = new ArrayList(1);
            ClosureExecuterAction cea = (ClosureExecuterAction)HudsonTestCase.this.jenkins.getExtensionList(RootAction.class).get(ClosureExecuterAction.class);
            UUID id = UUID.randomUUID();
            cea.add(id, new Runnable(){

                @Override
                public void run() {
                    try {
                        StaplerResponse rsp = Stapler.getCurrentResponse();
                        rsp.setStatus(200);
                        rsp.setContentType("text/html");
                        r.add(c.call());
                    }
                    catch (Exception e) {
                        t[0] = e;
                    }
                }
            });
            this.goTo("closures/?uuid=" + id);
            if (t[0] != null) {
                throw t[0];
            }
            return (V)r.get(0);
        }

        public HtmlPage search(String q) throws IOException, SAXException {
            HtmlPage top = this.goTo("");
            HtmlForm search = top.getFormByName("search");
            search.getInputByName("q").setValueAttribute(q);
            return (HtmlPage)HtmlFormUtil.submit(search, null);
        }

        public HtmlPage getPage(Run r) throws IOException, SAXException {
            return this.getPage(r, "");
        }

        public HtmlPage getPage(Run r, String relative) throws IOException, SAXException {
            return this.goTo(r.getUrl() + relative);
        }

        public HtmlPage getPage(Item item) throws IOException, SAXException {
            return this.getPage(item, "");
        }

        public HtmlPage getPage(Item item, String relative) throws IOException, SAXException {
            return this.goTo(item.getUrl() + relative);
        }

        public HtmlPage getPage(hudson.model.Node item) throws IOException, SAXException {
            return this.getPage(item, "");
        }

        public HtmlPage getPage(hudson.model.Node item, String relative) throws IOException, SAXException {
            return this.goTo(item.toComputer().getUrl() + relative);
        }

        public HtmlPage getPage(View view) throws IOException, SAXException {
            return this.goTo(view.getUrl());
        }

        public HtmlPage getPage(View view, String relative) throws IOException, SAXException {
            return this.goTo(view.getUrl() + relative);
        }

        public Page getPage(String url) throws IOException, FailingHttpStatusCodeException {
            try {
                Page page = super.getPage(url);
                return page;
            }
            finally {
                WebClientUtil.waitForJSExec(this);
            }
        }

        public HtmlPage goTo(String relative) throws IOException, SAXException {
            Page p = this.goTo(relative, "text/html");
            if (p instanceof HtmlPage) {
                return (HtmlPage)p;
            }
            throw new AssertionError((Object)("Expected text/html but instead the content type was " + p.getWebResponse().getContentType()));
        }

        public Page goTo(String relative, String expectedContentType) throws IOException, SAXException {
            Page p;
            while (relative.startsWith("/")) {
                relative = relative.substring(1);
            }
            try {
                p = super.getPage(this.getContextPath() + relative);
                WebClientUtil.waitForJSExec(this);
            }
            catch (IOException x) {
                if (x.getCause() != null) {
                    x.getCause().printStackTrace();
                }
                throw x;
            }
            TestCase.assertEquals((String)expectedContentType, (String)p.getWebResponse().getContentType());
            return p;
        }

        public XmlPage goToXml(String path) throws IOException, SAXException {
            Page page = this.goTo(path, "application/xml");
            if (page instanceof XmlPage) {
                return (XmlPage)page;
            }
            return null;
        }

        public void assertFails(String url, int statusCode) throws Exception {
            try {
                TestCase.fail((String)(url + " should have been rejected but produced: " + super.getPage(this.getContextPath() + url).getWebResponse().getContentAsString()));
            }
            catch (FailingHttpStatusCodeException x) {
                TestCase.assertEquals((int)statusCode, (int)x.getStatusCode());
            }
        }

        public String getContextPath() throws IOException {
            return HudsonTestCase.this.getURL().toExternalForm();
        }

        public WebRequest addCrumb(WebRequest req) {
            NameValuePair crumb = new NameValuePair(HudsonTestCase.this.jenkins.getCrumbIssuer().getDescriptor().getCrumbRequestField(), HudsonTestCase.this.jenkins.getCrumbIssuer().getCrumb(null));
            req.setRequestParameters(Arrays.asList(crumb));
            return req;
        }

        public URL createCrumbedUrl(String relativePath) throws IOException {
            CrumbIssuer issuer = HudsonTestCase.this.jenkins.getCrumbIssuer();
            String crumbName = issuer.getDescriptor().getCrumbRequestField();
            String crumb = issuer.getCrumb(null);
            return new URL(this.getContextPath() + relativePath + "?" + crumbName + "=" + crumb);
        }

        public HtmlPage eval(Runnable requestHandler) throws IOException, SAXException {
            ClosureExecuterAction cea = (ClosureExecuterAction)HudsonTestCase.this.jenkins.getExtensionList(RootAction.class).get(ClosureExecuterAction.class);
            UUID id = UUID.randomUUID();
            cea.add(id, requestHandler);
            return this.goTo("closures/?uuid=" + id);
        }

        public Dim interactiveJavaScriptDebugger() {
            Global global = new Global();
            HtmlUnitContextFactory cf = this.getJavaScriptEngine().getContextFactory();
            global.init((ContextFactory)cf);
            Dim dim = Main.mainEmbedded((ContextFactory)cf, (Scriptable)global, (String)("Rhino debugger: " + HudsonTestCase.this.getName()));
            dim.setBreakOnExceptions(true);
            return dim;
        }
    }

    public static class BreakException
    extends Exception {
    }
}

