/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenEmbedder;
import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.MavenAbstractArtifactRecord;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.model.Action;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class MavenAggregatedArtifactRecord
extends MavenAbstractArtifactRecord<MavenModuleSetBuild>
implements MavenAggregatedReport {
    public final MavenModuleSetBuild parent;

    public MavenAggregatedArtifactRecord(MavenModuleSetBuild build) {
        this.parent = build;
    }

    @Override
    public MavenModuleSetBuild getBuild() {
        return this.parent;
    }

    @Override
    public void update(Map<MavenModule, List<MavenBuild>> moduleBuilds, MavenBuild newBuild) {
    }

    public Class<MavenArtifactRecord> getIndividualActionType() {
        return MavenArtifactRecord.class;
    }

    @Override
    public Action getProjectAction(MavenModuleSet moduleSet) {
        return null;
    }

    @Exported(inline=true)
    public List<MavenArtifactRecord> getModuleRecords() {
        ArrayList<MavenArtifactRecord> r = new ArrayList<MavenArtifactRecord>();
        for (MavenBuild build : this.parent.getModuleLastBuilds().values()) {
            MavenArtifactRecord mar = (MavenArtifactRecord)build.getAction(MavenArtifactRecord.class);
            if (mar == null) continue;
            r.add(mar);
        }
        return r;
    }

    @Override
    public void deploy(MavenEmbedder embedder, ArtifactRepository deploymentRepository, TaskListener listener) throws MavenEmbedderException, IOException, ComponentLookupException, ArtifactDeploymentException {
        if (debug) {
            listener.getLogger().println("Redeploying artifacts of " + String.valueOf((Object)this.parent) + " timestamp=" + String.valueOf(this.parent.getTimestamp()));
        }
        for (MavenArtifactRecord mar : this.getModuleRecords()) {
            if (debug) {
                listener.getLogger().println("Deploying module: " + String.valueOf((Object)mar.parent) + " timestamp=" + String.valueOf(mar.parent.getTimestamp()));
            }
            mar.deploy(embedder, deploymentRepository, listener);
        }
    }
}

