/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.model.Api;
import hudson.model.BuildListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.util.VirtualFile;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public final class MavenArtifact
implements Serializable {
    @Exported
    public final String groupId;
    @Exported
    public final String artifactId;
    @Exported
    public final String version;
    @Exported
    public final String classifier;
    @Exported
    public final String type;
    @Exported
    public final String fileName;
    @Exported
    public final String canonicalName;
    @Exported
    public final String md5sum;
    private static final Logger LOGGER = Logger.getLogger(MavenArtifact.class.getName());
    private static final long serialVersionUID = 1L;

    public MavenArtifact(Artifact a) throws IOException {
        this.groupId = a.getGroupId();
        this.artifactId = a.getArtifactId();
        this.version = a.getVersion();
        this.classifier = a.getClassifier();
        this.type = a.getType();
        this.fileName = a.getFile().getName();
        this.md5sum = Util.getDigestOf((File)a.getFile());
        String extension = a.getArtifactHandler() != null ? a.getArtifactHandler().getExtension() : a.getType();
        this.canonicalName = this.getSeed(extension);
    }

    public MavenArtifact(String groupId, String artifactId, String version, String classifier, String type, String fileName, String md5sum) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.type = type;
        this.fileName = fileName;
        this.canonicalName = this.getSeed(type);
        this.md5sum = md5sum;
    }

    public static MavenArtifact create(Artifact a) throws IOException {
        File file = a.getFile();
        if (file == null) {
            return null;
        }
        if (!file.isFile()) {
            return null;
        }
        return new MavenArtifact(a);
    }

    public boolean isPOM() {
        return this.fileName.endsWith(".pom") || "pom.xml".equals(this.fileName);
    }

    @Deprecated
    public Artifact toArtifact(ArtifactHandlerManager handlerManager, ArtifactFactory factory, MavenBuild build) throws IOException {
        return this.toCloseableArtifact(handlerManager, factory, build).get();
    }

    public CloseableArtifact toCloseableArtifact(ArtifactHandlerManager handlerManager, ArtifactFactory factory, MavenBuild build) throws IOException {
        final String canonicalExtension = this.canonicalName.substring(this.canonicalName.lastIndexOf(46) + 1);
        ArtifactHandler ah = handlerManager.getArtifactHandler(this.type);
        HashMap handlers = Maps.newHashMap();
        handlers.put(this.type, new DefaultArtifactHandler(this.type){

            public String getExtension() {
                return canonicalExtension;
            }
        });
        if (!this.canonicalName.endsWith(ah.getExtension())) {
            handlerManager.addHandlers((Map)handlers);
        }
        Artifact a = factory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.type, this.classifier);
        TemporaryFile file = this.getTemporaryFile(build);
        a.setFile(file.getFile());
        return new CloseableArtifact(a, file);
    }

    private String getSeed(String extension) {
        String name = this.artifactId + "-" + this.version;
        if (Util.fixEmpty((String)this.classifier) != null) {
            name = name + "-" + this.classifier;
        }
        name = name + "." + extension;
        return name;
    }

    @Deprecated
    public File getFile(MavenBuild build) throws IOException {
        File artifactsDir = build.getArtifactsDir();
        File f = new File(new File(new File(new File(artifactsDir, this.groupId), this.artifactId), this.version), this.canonicalName);
        if (!f.exists()) {
            throw new FileNotFoundException("Archived artifact is missing: " + String.valueOf(f));
        }
        return f;
    }

    @NonNull
    public TemporaryFile getTemporaryFile(MavenBuild build) {
        return new TemporaryFile(build);
    }

    public HttpResponse doFile(final @AncestorInPath MavenArtifactRecord parent) throws IOException {
        return new HttpResponse(){

            public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException {
                IOUtils.copy((InputStream)parent.parent.getArtifactManager().root().child(MavenArtifact.this.artifactPath()).open(), (OutputStream)rsp.getOutputStream());
            }
        };
    }

    private String artifactPath() {
        return this.groupId + "/" + this.artifactId + "/" + this.version + "/" + this.canonicalName;
    }

    public void archive(MavenBuildProxy build, File file, BuildListener listener) throws IOException, InterruptedException {
        if (build.isArchivingDisabled()) {
            LOGGER.fine("Archiving disabled - not archiving " + String.valueOf(file));
        } else {
            build.queueArchiving(this.artifactPath(), file.getAbsolutePath());
        }
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public static final class CloseableArtifact
    implements Closeable {
        private final Artifact artifact;
        private final Closeable closeable;

        CloseableArtifact(Artifact artifact, Closeable closeable) {
            this.artifact = artifact;
            this.closeable = closeable;
        }

        public Artifact get() {
            return this.artifact;
        }

        @Override
        public void close() throws IOException {
            this.closeable.close();
        }
    }

    public final class TemporaryFile
    implements Closeable {
        private final MavenBuild build;
        private File copy;

        TemporaryFile(MavenBuild build) {
            this.build = build;
        }

        @NonNull
        public VirtualFile getVirtualFile() {
            return this.build.getArtifactManager().root().child(MavenArtifact.this.artifactPath());
        }

        @NonNull
        public synchronized File getFile() throws IOException {
            if (this.copy == null) {
                try {
                    return MavenArtifact.this.getFile(this.build);
                }
                catch (FileNotFoundException x) {
                    File f = File.createTempFile("jenkins-", MavenArtifact.this.canonicalName);
                    f.deleteOnExit();
                    try (FileOutputStream os = new FileOutputStream(f);){
                        IOUtils.copy((InputStream)this.getVirtualFile().open(), (OutputStream)os);
                    }
                    this.copy = f;
                }
            }
            return this.copy;
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.copy != null) {
                try {
                    if (!this.copy.delete()) {
                        throw new IOException("could not delete " + String.valueOf(this.copy));
                    }
                }
                finally {
                    this.copy = null;
                }
            }
        }
    }
}

