/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import hudson.maven.agent.AbortException;
import java.io.IOException;
import org.apache.maven.BuildFailureException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.DefaultLifecycleExecutor;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutorListener;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.monitor.event.EventMonitor;

public class LifecycleExecutorInterceptor
extends DefaultLifecycleExecutor {
    private static LifecycleExecutorListener listener;

    public static void setListener(LifecycleExecutorListener _listener) {
        listener = _listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException {
        try {
            session.getEventDispatcher().addEventMonitor((EventMonitor)new EventMonitorImpl());
            if (listener != null) {
                listener.preBuild(session, rm, dispatcher);
            }
            try {
                super.execute(session, rm, dispatcher);
            }
            finally {
                if (listener != null) {
                    listener.postBuild(session, rm, dispatcher);
                }
            }
        }
        catch (InterruptedException e) {
            throw new BuildFailureException("aborted", (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildFailureException(e.getMessage(), (Throwable)e);
        }
        catch (AbortException e) {
            throw new BuildFailureException("aborted", (Throwable)e);
        }
    }

    private final class EventMonitorImpl
    implements EventMonitor {
        private EventMonitorImpl() {
        }

        public void startEvent(String eventName, String target, long timestamp) {
        }

        public void endEvent(String eventName, String target, long timestamp) {
            if (eventName.equals("project-execute") && listener != null) {
                try {
                    listener.endModule();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        }

        public void errorEvent(String eventName, String target, long timestamp, Throwable cause) {
        }
    }
}

